/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.http.responses;

import com.googlecode.openbox.http.AbstractResponse;
import com.googlecode.openbox.http.ExecutorMonitorManager;
import com.googlecode.openbox.http.GsonFactory;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonResponse<T>
extends AbstractResponse {
    private static final Logger logger = LogManager.getLogger();
    private T jsonObject;

    public JsonResponse(HttpResponse httpResponse, HttpContext httpContext, ExecutorMonitorManager executorMonitorManager, Class<T> classT) {
        super(httpResponse, httpContext, executorMonitorManager);
        try {
            this.jsonObject = GsonFactory.createGson().fromJson(this.getContent(), classT);
        }
        catch (Exception e) {
            logger.error("jsonObject will be null , can't build JSON response object to type[" + classT.getName() + "] with response content [" + this.getContent() + "]", (Throwable)e);
        }
    }

    public T getJsonObject() {
        return this.jsonObject;
    }

    @Override
    public ContentType[] getSupportedContentTypes() {
        return new ContentType[]{JsonResponse.getUtf8ContentType(ContentType.APPLICATION_JSON)};
    }

    public String toString() {
        return GsonFactory.createGson().toJson(this.jsonObject);
    }
}

