/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.http.responses;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ResponseUtils {
    private static final Logger logger = LogManager.getLogger();

    private ResponseUtils() {
    }

    public static int getStatusCode(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    public static Header[] getAllHeaders(HttpResponse response) {
        return response.getAllHeaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringContent(HttpResponse response) {
        HttpEntity entity = response.getEntity();
        try {
            String string = entity == null ? "" : EntityUtils.toString((HttpEntity)entity);
            return string;
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("get string content from http response error , so return empty ", (Throwable)e);
            }
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)entity);
        }
        return "";
    }

    public static void assertContentType(ContentType[] supportedTypes, HttpResponse httpResponse) {
    }
}

