/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.log;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.PluginManager;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.testng.Reporter;

@Plugin(name="TestngReportAppender", category="Core", elementType="appender", printObject=true)
public final class TestngReportAppender
extends AbstractAppender {
    private boolean justContent;

    private TestngReportAppender(String name, Filter filter, Layout<? extends Serializable> layout, String justContent) {
        super(name, filter, layout);
        this.justContent = null == justContent ? false : Boolean.parseBoolean(justContent);
    }

    @PluginFactory
    public static TestngReportAppender createAppender(@PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filters") Filter filter, @PluginAttribute(value="name") String name, @PluginAttribute(value="justContent") String justContent) {
        if (name == null) {
            LOGGER.error("No name provided for TestngReportAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createLayout(null, null, null, null, null);
        }
        return new TestngReportAppender(name, filter, (Layout<? extends Serializable>)layout, justContent);
    }

    public void append(LogEvent event) {
        String logContent = null;
        if (this.justContent) {
            logContent = event.getMessage().getFormattedMessage();
        } else {
            byte[] bytes = this.getLayout().toByteArray(event);
            try {
                logContent = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        Reporter.log((String)logContent);
    }

    private static void install() {
        TestngReportAppender.install(TestngReportAppender.class);
    }

    public static boolean install(Class<?> loadClass) {
        String startPackage = TestngReportAppender.class.getPackage().getName();
        String output = loadClass.getClassLoader().getResource("//").getPath();
        try {
            PluginManager.main((String[])new String[]{output, startPackage});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public static void main(String ... args) {
        TestngReportAppender.install();
        Logger logger = LogManager.getLogger();
        logger.info("\n!!!!test install success !!!!\n");
    }
}

