/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.server;

import com.googlecode.openbox.server.Server;
import com.googlecode.openbox.server.ServerGroup;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractServerGroup
implements ServerGroup {
    private final Map<String, Server> serverGroup = new HashMap<String, Server>();

    @Override
    public void addServer(Server server) {
        this.serverGroup.put(server.getIp(), server);
    }

    @Override
    public void addServers(ServerGroup serverGroup) {
        Server[] servers;
        for (Server server : servers = serverGroup.listServers()) {
            this.addServer(server);
        }
    }

    @Override
    public int getNum() {
        return this.serverGroup.size();
    }

    @Override
    public boolean isEmpty() {
        return this.serverGroup.isEmpty();
    }

    @Override
    public Server getServer(String host) {
        return this.serverGroup.get(host);
    }

    @Override
    public void removeServer(String host) {
        this.serverGroup.remove(host);
    }

    @Override
    public void clearAll() {
        this.serverGroup.clear();
    }

    @Override
    public Server[] listServers() {
        return this.serverGroup.values().toArray(new Server[0]);
    }

    @Override
    public String[] listServerHosts() {
        Server[] servers = this.listServers();
        int num = servers.length;
        String[] serverHosts = new String[num];
        for (int i = 0; i < num; ++i) {
            serverHosts[i] = servers[i].getIp();
        }
        return serverHosts;
    }
}

