/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.server;

import com.googlecode.openbox.server.Server;
import com.googlecode.openbox.server.SshRequest;

public class DefaultSshRequest
implements SshRequest {
    private Server server;
    private static final ThreadLocal<String> commandPool = new ThreadLocal();
    private static final ThreadLocal<String> resposnePool = new ThreadLocal();

    public DefaultSshRequest(Server server) {
        this.server = server;
    }

    @Override
    public void send(String sshCommand) {
        commandPool.set(sshCommand);
        resposnePool.set(this.server.getSshClient(false).executeSingleCommand(System.out, commandPool.get()));
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public String getCommand() {
        return commandPool.get();
    }

    @Override
    public String getResponse() {
        return resposnePool.get();
    }
}

