/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.server;

import com.googlecode.openbox.common.ExecuteResult;
import com.googlecode.openbox.server.AbstractServerGroup;
import com.googlecode.openbox.server.Server;

public class SequenceServerGroup
extends AbstractServerGroup {
    public static SequenceServerGroup newInstance() {
        return new SequenceServerGroup();
    }

    @Override
    public ExecuteResult executeShell(String shell) {
        Server[] servers = this.listServers();
        ExecuteResult executeResult = ExecuteResult.newInstance((boolean)true);
        for (Server server : servers) {
            try {
                server.getSshClient().executeShellByFTP(System.out, shell);
                executeResult.appendMessage("execute shell on server :" + server + " success !");
            }
            catch (Exception e) {
                executeResult.setResult(false);
                executeResult.appendMessage("execute shell on server :" + server + " failed !");
            }
        }
        return executeResult;
    }

    @Override
    public ExecuteResult executeCommands(String command) {
        Server[] servers = this.listServers();
        ExecuteResult executeResult = ExecuteResult.newInstance((boolean)true);
        for (Server server : servers) {
            try {
                server.getSshClient().executeCommand(System.out, command);
                executeResult.appendMessage("execute command on server :" + server + " success !");
            }
            catch (Exception e) {
                executeResult.setResult(false);
                executeResult.appendMessage("execute command on server :" + server + " failed !");
            }
        }
        return executeResult;
    }

    @Override
    public String[] executeSingleCommandGetResponse(String command) {
        Server[] servers = this.listServers();
        int num = servers.length;
        String[] responses = new String[num];
        ExecuteResult executeResult = ExecuteResult.newInstance((boolean)true);
        for (int i = 0; i < num; ++i) {
            Server server = servers[i];
            try {
                responses[i] = server.getSshClient().executeSingleCommand(System.out, command);
                executeResult.appendMessage("execute command on server :" + server + " success !");
                continue;
            }
            catch (Exception e) {
                executeResult.setResult(false);
                executeResult.appendMessage("execute command on server :" + server + " failed !");
            }
        }
        return responses;
    }
}

