/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.server;

import com.googlecode.openbox.server.ssh.CommonSshClient;
import com.googlecode.openbox.server.ssh.SshClient;

public class Server {
    private String ip;
    private int sshPort;
    private String username;
    private String password;

    public Server(String ip, int sshPort, String username, String password) {
        this.ip = ip;
        this.sshPort = sshPort;
        this.username = username;
        this.password = password;
    }

    public static Server newInstance(String ip, int sshPort, String username, String password) {
        return new Server(ip, sshPort, username, password);
    }

    public SshClient getSshClient() {
        return this.getSshClient(false);
    }

    public SshClient getSshClient(boolean needCmdWrapper) {
        CommonSshClient sshClient = CommonSshClient.newInstance(this.getIp(), this.getSshPort(), this.getUsername(), this.getPassword());
        sshClient.setNeedSource(needCmdWrapper);
        return sshClient;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        return "{ ip=[" + this.ip + "],sshPort=[" + this.sshPort + "],username=[" + this.username + "],password=[" + this.password + "] }";
    }
}

