/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.server;

public interface ServerValidator {
    public static final CommandGenerator DEFAULT_COMMAND_GENERATOR = new CommandGenerator(){

        @Override
        public String generate(String seed) {
            return seed;
        }
    };
    public static final CommandGenerator ENV_VAR_COMMAND_GENERATOR = new CommandGenerator(){

        @Override
        public String generate(String seed) {
            return "echo ${" + seed + "}";
        }
    };
    public static final CommandGenerator SYSCTL_COMMAND_GENERATOR = new CommandGenerator(){

        @Override
        public String generate(String seed) {
            return "sysctl -a | grep " + seed;
        }
    };
    public static final CommandGenerator ULIMIT_COMMAND_GENERATOR = new CommandGenerator(){

        @Override
        public String generate(String seed) {
            return "ulimit -a | grep " + seed;
        }
    };
    public static final Checker EQ_CHECKER = new Checker(){

        @Override
        public boolean check(String excepted, String actual) {
            if (null == excepted || null == actual) {
                return false;
            }
            return excepted.endsWith(actual);
        }
    };
    public static final Checker INCLUDE_CHECKER = new Checker(){

        @Override
        public boolean check(String excepted, String actual) {
            if (null == excepted || null == actual) {
                return false;
            }
            return actual.indexOf(excepted) > -1;
        }
    };

    public boolean checkEnvironmentVariableEqual(String var1, String var2);

    public boolean checkEnvironmentVariableInclude(String var1, String var2);

    public boolean checkEnvironmentVariable(String var1, String var2, Checker var3);

    public boolean checkSysctlVariable(String var1, String var2);

    public boolean checkUlimitVariable(String var1, String var2);

    public boolean executeCheck(Checker var1, String var2, String ... var3);

    public boolean executeCheckInclude(String var1, String ... var2);

    public boolean executeCheckEqual(String var1, String ... var2);

    public boolean executeCheckInclude(CommandGenerator var1, String var2, String ... var3);

    public boolean executeCheckEqual(CommandGenerator var1, String var2, String ... var3);

    public boolean executeCheck(CommandGenerator var1, Checker var2, String var3, String ... var4);

    public static interface Checker {
        public boolean check(String var1, String var2);
    }

    public static interface CommandGenerator {
        public String generate(String var1);
    }
}

