/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.server;

import com.googlecode.openbox.server.ServerGroup;
import com.googlecode.openbox.server.ServerValidator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerValidatorImpl
implements ServerValidator {
    private static final Logger logger = LogManager.getLogger();
    private ServerGroup serverGroup;

    public ServerValidatorImpl(ServerGroup serverGroup) {
        this.serverGroup = serverGroup;
    }

    public static ServerValidatorImpl newInstance(ServerGroup serverGroup) {
        return new ServerValidatorImpl(serverGroup);
    }

    private ServerGroup getServerGroup() {
        return this.serverGroup;
    }

    private String[] executeCommand(String command) {
        return this.getServerGroup().executeSingleCommandGetResponse(command);
    }

    @Override
    public boolean executeCheck(ServerValidator.Checker checker, String command, String ... expecteds) {
        return this.executeCheck(DEFAULT_COMMAND_GENERATOR, checker, command, expecteds);
    }

    @Override
    public boolean checkEnvironmentVariableEqual(String varName, String varValue) {
        return this.checkEnvironmentVariable(varName, varValue, EQ_CHECKER);
    }

    @Override
    public boolean checkEnvironmentVariableInclude(String varName, String varValue) {
        return this.checkEnvironmentVariable(varName, varValue, INCLUDE_CHECKER);
    }

    @Override
    public boolean checkEnvironmentVariable(String varName, String varValue, ServerValidator.Checker checker) {
        return this.executeCheck(ENV_VAR_COMMAND_GENERATOR, checker, varName, varValue);
    }

    @Override
    public boolean checkSysctlVariable(String varName, String varValue) {
        return this.executeCheck(SYSCTL_COMMAND_GENERATOR, INCLUDE_CHECKER, varName, varValue);
    }

    @Override
    public boolean checkUlimitVariable(String varName, String varValue) {
        return this.executeCheck(ULIMIT_COMMAND_GENERATOR, INCLUDE_CHECKER, varName, varValue);
    }

    @Override
    public boolean executeCheck(ServerValidator.CommandGenerator cmdGenerator, ServerValidator.Checker checker, String seed, String ... expecteds) {
        String checkCmd = cmdGenerator.generate(seed);
        String[] values = this.executeCommand(checkCmd);
        boolean result = true;
        for (String actual : values) {
            for (String expected : expecteds) {
                if (checker.check(expected, actual)) {
                    if (!logger.isInfoEnabled()) continue;
                    logger.info("[SUCCESS]environment check as [" + seed + "],exceptedValue=[" + expected + "],actualValue=[" + actual + "]");
                    continue;
                }
                if (logger.isInfoEnabled()) {
                    logger.info("[FAIL]environment check as [" + seed + "],exceptedValue=[" + expected + "],actualValue=[" + actual + "]");
                }
                result = false;
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("above group overall check result is [" + result + "]");
        }
        return result;
    }

    @Override
    public boolean executeCheckInclude(String command, String ... expecteds) {
        return this.executeCheck(INCLUDE_CHECKER, command, expecteds);
    }

    @Override
    public boolean executeCheckEqual(String command, String ... expecteds) {
        return this.executeCheck(EQ_CHECKER, command, expecteds);
    }

    @Override
    public boolean executeCheckInclude(ServerValidator.CommandGenerator cmdGenerator, String seed, String ... expecteds) {
        return this.executeCheck(cmdGenerator, INCLUDE_CHECKER, seed, expecteds);
    }

    @Override
    public boolean executeCheckEqual(ServerValidator.CommandGenerator cmdGenerator, String seed, String ... expecteds) {
        return this.executeCheck(cmdGenerator, EQ_CHECKER, seed, expecteds);
    }
}

