/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.server.loaders;

import com.googlecode.openbox.server.AbstractServerGroup;
import com.googlecode.openbox.server.ConcurrentServerGroup;
import com.googlecode.openbox.server.SequenceServerGroup;
import com.googlecode.openbox.server.Server;
import com.googlecode.openbox.server.ServerGroup;
import com.googlecode.openbox.server.loaders.ServerGroupLoader;

public abstract class AbstractServerGroupLoader
implements ServerGroupLoader {
    private String username;
    private String password;
    private int port;

    public AbstractServerGroupLoader(String username, String password, int port) {
        this.username = username;
        this.password = password;
        this.port = port;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public ServerGroup toServerGroup(boolean isConcurrent) {
        String[] ips;
        AbstractServerGroup sg = null;
        sg = isConcurrent ? ConcurrentServerGroup.newInstance() : SequenceServerGroup.newInstance();
        for (String ip : ips = this.getIps()) {
            Server server = Server.newInstance(ip, this.getPort(), this.getUsername(), this.getPassword());
            sg.addServer(server);
        }
        return sg;
    }
}

