/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.server.log;

import com.googlecode.openbox.server.log.ServerLog;
import com.googlecode.openbox.server.ssh.SshClient;

public abstract class AbstractServerLog
implements ServerLog {
    public static final String PATH_SPLIT = "/";
    private volatile SshClient sshClient = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SshClient getSshClient() {
        if (null != this.sshClient) return this.sshClient;
        String string = PATH_SPLIT;
        synchronized (PATH_SPLIT) {
            if (null != this.sshClient) return this.sshClient;
            this.sshClient = this.getServer().getSshClient();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.sshClient;
        }
    }

    @Override
    public String getPath() {
        return this.getHome() + PATH_SPLIT + this.getName();
    }

    @Override
    public String getContentByCommand(String command) {
        return this.getSshClient().executeSingleCommand(System.out, command + " " + this.getPath());
    }

    @Override
    public int getCurrentLineNum() {
        String response = null;
        try {
            String path = this.getPath();
            response = this.getContentByCommand("wc -l ");
            response = response.replaceAll(path, "");
            return Integer.parseInt(response.trim());
        }
        catch (Exception e) {
            throw new RuntimeException("get server log current line num failed as response is :" + response);
        }
    }

    @Override
    public String getLastestContent(int fromLineNum) {
        return this.getContentByCommand("sed -n '" + fromLineNum + ",$p' ");
    }

    @Override
    public String getContentBetween(int beginLineNum, int endLineNum) {
        if (beginLineNum < 1) {
            throw new RuntimeException("beginLineNum sould > 0 , but your beginLineNum is " + beginLineNum);
        }
        if (beginLineNum > endLineNum) {
            throw new RuntimeException("beginLineNum sould <= endLineNum , but is >");
        }
        return this.getContentByCommand("sed -n '" + beginLineNum + "," + endLineNum + "p' ");
    }

    @Override
    public String grepContentByKeys(String ... keys) {
        String command = "";
        for (int i = 0; i < keys.length; ++i) {
            command = i == 0 ? command + "grep " + keys[i] + " " : command + " | grep " + keys[i];
        }
        return this.getContentByCommand(command);
    }

    @Override
    public String grepContentByKeysFrom(int beginLineNum, String ... keys) {
        String command = "sed -n '" + beginLineNum + ",$p' ";
        for (int i = 0; i < keys.length; ++i) {
            command = command + " | grep " + keys[i];
        }
        return this.getContentByCommand(command);
    }

    @Override
    public void deleteLog() {
        String command = "rm -rf ";
        this.getContentByCommand(command);
    }

    @Override
    public void emptyLogByNewLogContent(String newLogContent) {
        String command = "echo '' > ";
        this.getContentByCommand(command);
    }
}

