/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.server.ssh;

import com.googlecode.openbox.common.IOUtils;
import com.googlecode.openbox.server.ssh.SshClient;
import com.googlecode.openbox.server.ssh.SshException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractSshClient
implements SshClient {
    private static final Logger logger = LogManager.getLogger();
    public static final String TEMP_PATH = "/var";
    public static final String LATEEST_EXEC_SHELL_DEBUG = "/var/latest_exec_debug.sh";

    @Override
    public void uploadFile(OutputStream output, String fileName, File file, String serverLocation) {
        if (logger.isInfoEnabled()) {
            logger.info("sftp upload file [" + file + "] to target location [" + serverLocation + "] with file name is [" + fileName + "]");
        }
        FileInputStream fileContent = null;
        try {
            if (!file.exists()) {
                logger.error("sftp upload local file [" + file + "] can't find !");
            }
            fileContent = new FileInputStream(file);
            this.uploadFile(output, fileName, fileContent, serverLocation);
        }
        catch (FileNotFoundException e) {
            String message = "[GSSH-FTP] ERROR as: sftp upload local file [" + file + "] can't find !";
            logger.error(message, (Throwable)e);
            throw new SshException(message, e);
        }
        catch (Exception e) {
            String message = "[GSSH-FTP] ERROR as with below errors logs:";
            throw new SshException(message, e);
        }
        finally {
            if (null != fileContent) {
                try {
                    ((InputStream)fileContent).close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public void uploadFile(OutputStream output, String fileName, String fileContent, String serverLocation) {
        ByteArrayInputStream bis = new ByteArrayInputStream(fileContent.getBytes());
        this.uploadFile(output, fileName, bis, serverLocation);
        if (null != bis) {
            try {
                ((InputStream)bis).close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void downloadFile(OutputStream output, String remoteFile, String localFolder) {
        File rf = new File(remoteFile);
        this.downloadFile(output, remoteFile, localFolder, rf.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeShellByFTP(OutputStream output, InputStream shell) {
        Random random = new Random();
        String shellName = "tempshell_" + System.currentTimeMillis() + random.nextInt() + ".sh";
        String shellFile = "/var/" + shellName;
        try {
            this.uploadFile(output, shellName, shell, TEMP_PATH);
            this.chmod(output, 777, shellFile);
            this.executeCommand(output, ". " + shellFile);
        }
        finally {
            this.rm_Rf(output, LATEEST_EXEC_SHELL_DEBUG);
            this.mv(output, shellFile, LATEEST_EXEC_SHELL_DEBUG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeShellByFTP(OutputStream output, String shell) {
        Random random = new Random();
        if (logger.isInfoEnabled()) {
            logger.info("execute shell as : ");
            logger.info(shell);
        }
        String shellName = "tempshell_" + System.currentTimeMillis() + random.nextInt() + ".sh";
        String shellFile = "/var/" + shellName;
        try {
            this.uploadFile(output, shellName, shell, TEMP_PATH);
            this.chmod(output, 777, shellFile);
            this.executeCommand(output, ". " + shellFile);
        }
        finally {
            this.rm_Rf(output, LATEEST_EXEC_SHELL_DEBUG);
            this.mv(output, shellFile, LATEEST_EXEC_SHELL_DEBUG);
        }
    }

    @Override
    public void chmod(OutputStream output, int mode, String path) {
        this.executeCommand(output, "chmod " + mode + " " + path);
    }

    @Override
    public void chown(OutputStream output, String own, String path) {
        this.executeCommand(output, "chown " + own + " " + path);
    }

    @Override
    public void mv(OutputStream output, String source, String dest) {
        this.executeCommand(output, "mv " + source + " " + dest);
    }

    @Override
    public void rm_Rf(OutputStream output, String path) {
        this.executeCommand(output, "rm -rf " + path);
    }

    public void executeCommand(OutputStream output, InputStream command) {
        String content = IOUtils.getStringFromStream((InputStream)command);
        this.executeCommand(output, content);
    }
}

