/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.server.ssh;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommonLinuxClient {
    private static final Logger logger = LogManager.getLogger();
    private String ip;
    private int port;
    private String username;
    private String password;
    private Connection conn;
    private Session session;
    private PrintWriter out;
    private BufferedReader stdoutReader;
    private BufferedReader stderrReader;

    public CommonLinuxClient(String ip, int port, String username, String password) {
        this.ip = ip;
        this.port = port;
        this.username = username;
        this.password = password;
        this.initConnection();
        this.initSession();
    }

    public static CommonLinuxClient newInstance(String ip, int port, String username, String password) {
        return new CommonLinuxClient(ip, port, username, password);
    }

    private void initConnection() {
        try {
            this.conn = new Connection(this.ip, this.port);
            this.conn.connect();
            boolean isAuthenticated = this.conn.authenticateWithPassword(this.username, this.password);
            if (!isAuthenticated) {
                throw new IOException("Authentication failed.");
            }
            if (logger.isInfoEnabled()) {
                logger.info("\nssh login success to ip=[" + this.ip + "],port=[" + this.port + "],username=[" + this.username + "],password=[*******]");
            }
        }
        catch (Exception e) {
            String msg = "\nSSH Connection and Login error to ip=[" + this.ip + "],port=[" + this.port + "],username=[" + this.username + "],password=[*******]";
            logger.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    private void initSession() {
        try {
            this.session = this.conn.openSession();
            this.session.requestDumbPTY();
            this.session.startShell();
            this.stdoutReader = new BufferedReader(new InputStreamReader(this.session.getStdout()));
            this.stderrReader = new BufferedReader(new InputStreamReader(this.session.getStderr()));
            this.out = new PrintWriter(this.session.getStdin());
        }
        catch (Exception e) {
            String msg = "\nOpen SSH2 Session Error !";
            logger.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    public String execute(String command) {
        this.out.println(command);
        StringBuilder sb = new StringBuilder();
        try {
            int errLen;
            char[] buffer = new char[2048];
            int stdOutConditions = this.session.waitForCondition(125, 3000L);
            if ((stdOutConditions & 4) != 0) {
                int len = this.stdoutReader.read(buffer);
                if (len > 0) {
                    sb.append(buffer, 0, len);
                }
            } else if ((stdOutConditions & 8) != 0 && (errLen = this.stderrReader.read(buffer)) > 0) {
                sb.append(buffer, 0, errLen);
            }
            String response = sb.toString();
            if (logger.isInfoEnabled()) {
                logger.info("\n" + response);
            }
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException("execute comand [" + command + "] error !", e);
        }
    }

    public void close() {
        if (null != this.stdoutReader) {
            try {
                this.stdoutReader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (null != this.stderrReader) {
            try {
                this.stderrReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (null != this.out) {
            this.out.close();
        }
        if (null != this.session) {
            this.session.close();
        }
        if (null != this.conn) {
            this.conn.close();
        }
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

