/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.server.ssh;

import com.googlecode.openbox.server.ssh.DefaultSshClient;
import com.googlecode.openbox.server.ssh.SshException;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommonSshClient
extends DefaultSshClient {
    private static final Logger logger = LogManager.getLogger();

    public CommonSshClient(String ip, int port, String username, String password) {
        super(ip, port, username, password);
    }

    public static CommonSshClient newInstance(String ip, int port, String username, String password) {
        return new CommonSshClient(ip, port, username, password);
    }

    public Connection getConnection() throws IOException {
        Connection conn = new Connection(this.getIp(), this.getPort());
        conn.connect();
        boolean isAuthenticated = conn.authenticateWithPassword(this.getUsername(), this.getPassword());
        if (!isAuthenticated) {
            throw new IOException("Authentication failed.");
        }
        if (logger.isInfoEnabled()) {
            logger.info("\nssh login success to ip=[" + this.getIp() + "],port=[" + this.getPort() + "],username=[" + this.getUsername() + "],password=[*******]");
        }
        return conn;
    }

    @Override
    public void executeCommand(OutputStream output, String command) {
        Connection conn = null;
        try {
            conn = this.getConnection();
        }
        catch (Exception e) {
            throw new SshException("create ssh session failed with ip=[" + this.getIp() + "],port=[" + this.getPort() + "],username=[" + this.getUsername() + "],password=[" + this.getPassword() + "]", e);
        }
        Session session = null;
        String wrappedCommand = this.wrapperInput(command);
        try {
            session = conn.openSession();
            session.requestPTY("dumb");
            session.startShell();
            ExecutorService exec = Executors.newSingleThreadExecutor();
            Future<String> task = exec.submit(new OutputTask(session, output));
            PrintWriter out = new PrintWriter(session.getStdin());
            String[] commands = wrappedCommand.split("\n");
            for (int i = 0; i < commands.length; ++i) {
                String cmd = commands[i];
                if ("".equals(cmd.trim())) continue;
                out.println(cmd);
            }
            out.println("exit 0");
            out.close();
            task.get();
            exec.shutdown();
            if (logger.isInfoEnabled()) {
                logger.info("exit status -->" + session.getExitStatus());
            }
        }
        catch (Exception e) {
            String msg = "execute commds=[" + wrappedCommand + "]failed !";
            throw new SshException(msg, e);
        }
        finally {
            if (null != session) {
                session.close();
            }
            if (null != conn) {
                conn.close();
            }
        }
    }

    class OutputTask
    implements Callable<String> {
        private OutputStream output;
        private Session session;

        public String execute() throws IOException, InterruptedException {
            InputStream stdout = this.session.getStdout();
            InputStream stderr = this.session.getStderr();
            byte[] buffer = new byte[8192];
            block0: while (true) {
                int len;
                if (stdout.available() == 0 && stderr.available() == 0) {
                    int conditions = this.session.waitForCondition(44, 600000L);
                    if ((conditions & 1) != 0) {
                        if (!logger.isInfoEnabled()) break;
                        logger.info("wait timeout and exit now !");
                        break;
                    }
                    if ((conditions & 0x20) != 0) break;
                }
                while (stdout.available() > 0) {
                    len = stdout.read(buffer);
                    if (len <= 0) continue;
                    this.output.write(buffer, 0, len);
                }
                while (true) {
                    if (stderr.available() <= 0) continue block0;
                    len = stderr.read(buffer);
                    if (len <= 0) continue;
                    this.output.write(buffer, 0, len);
                }
                break;
            }
            if (logger.isInfoEnabled()) {
                logger.info("####################################");
            }
            return "SUCCESS";
        }

        @Override
        public String call() throws Exception {
            Thread.sleep(2000L);
            return this.execute();
        }

        public OutputTask(Session session, OutputStream output) {
            this.session = session;
            this.output = output;
        }
    }
}

