/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.server.ssh;

import com.googlecode.openbox.common.IOUtils;
import com.googlecode.openbox.server.ssh.AbstractSshClient;
import com.googlecode.openbox.server.ssh.SshException;
import com.googlecode.openbox.server.ssh.SshUserInfo;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultSshClient
extends AbstractSshClient {
    private static final Logger logger = LogManager.getLogger();
    public static final String SSH_PROFILE = "source /etc/profile;source ~/.bash_profile;source ~/.bashrc\n";
    public static final String SSH_BEY_KEY = "congrats , done for your shell!";
    public static final String SSH_BEY = "\necho 'congrats , done for your shell!'";
    private String ip;
    private int port;
    private String username;
    private String password;
    private boolean needSource;

    public DefaultSshClient(String ip, int port, String username, String password) {
        this.ip = ip;
        this.port = port;
        this.username = username;
        this.password = password;
        this.needSource = true;
    }

    public static DefaultSshClient newInstance(String ip, int port, String username, String password) {
        return new DefaultSshClient(ip, port, username, password);
    }

    public Session createSession(OutputStream output) {
        JSch jsch = new JSch();
        Session session = null;
        try {
            session = jsch.getSession(this.username, this.ip, this.port);
            session.setPassword(this.password);
            SshUserInfo ui = new SshUserInfo(this.password);
            session.setUserInfo((UserInfo)ui);
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.setDaemonThread(false);
            session.connect();
            if (logger.isInfoEnabled()) {
                logger.info("\nssh login success to ip=[" + this.ip + "],port=[" + this.port + "],username=[" + this.username + "],password=[*******]");
            }
        }
        catch (Exception e) {
            throw new SshException("create ssh session failed with ip=[" + this.ip + "],port=[" + this.port + "],username=[" + this.username + "],password=[" + this.password + "]", e);
        }
        return session;
    }

    @Override
    public void uploadFile(OutputStream output, String fileName, InputStream fileContent, String serverLocation) {
        OutputStream out;
        ChannelSftp sftp;
        Session session;
        block13: {
            session = null;
            sftp = null;
            out = null;
            try {
                session = this.createSession(output);
                Channel channel = session.openChannel("sftp");
                channel.setOutputStream(output, true);
                channel.setExtOutputStream(output, true);
                channel.connect();
                Thread.sleep(2000L);
                sftp = (ChannelSftp)channel;
                sftp.setFilenameEncoding("UTF-8");
                sftp.cd(serverLocation);
                out = sftp.put(fileName, 777);
                Thread.sleep(2000L);
                byte[] buffer = new byte[2048];
                int n = -1;
                while ((n = fileContent.read(buffer, 0, 2048)) != -1) {
                    out.write(buffer, 0, n);
                }
                out.flush();
                if (!logger.isInfoEnabled()) break block13;
                logger.info("upload file [" + fileName + "] to remote [" + serverLocation + "]success");
            }
            catch (Exception e) {
                try {
                    throw new SshException("[GSSH - SFTP]  Exception:" + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    if (logger.isInfoEnabled()) {
                        logger.info("[GSSH]-SFTP exit status is " + sftp.getExitStatus());
                    }
                    if (null != out) {
                        try {
                            out.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    this.closeSession(session, (Channel)sftp);
                    throw throwable;
                }
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("[GSSH]-SFTP exit status is " + sftp.getExitStatus());
        }
        if (null != out) {
            try {
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.closeSession(session, (Channel)sftp);
    }

    @Override
    public void downloadFile(OutputStream output, String remoteFile, String localFolder, String fileName) {
        OutputStream out;
        ChannelSftp sftp;
        Session session;
        block12: {
            session = null;
            sftp = null;
            out = null;
            try {
                session = this.createSession(output);
                Channel channel = session.openChannel("sftp");
                channel.connect();
                Thread.sleep(2000L);
                sftp = (ChannelSftp)channel;
                sftp.setFilenameEncoding("UTF-8");
                sftp.get(remoteFile, localFolder + "/" + fileName);
                if (!logger.isInfoEnabled()) break block12;
                logger.info("download remote file [" + remoteFile + "] to local [" + localFolder + "] with file name [" + fileName + "]");
            }
            catch (Exception e) {
                try {
                    throw new SshException(e);
                }
                catch (Throwable throwable) {
                    if (logger.isInfoEnabled()) {
                        logger.info("[GSSH]-SFTP exit status is " + sftp.getExitStatus());
                    }
                    if (null != out) {
                        try {
                            out.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    this.closeSession(session, (Channel)sftp);
                    throw throwable;
                }
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("[GSSH]-SFTP exit status is " + sftp.getExitStatus());
        }
        if (null != out) {
            try {
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.closeSession(session, (Channel)sftp);
    }

    @Override
    public void executeShell(OutputStream output, String shell) {
        String wrapperShell = this.wrapperInput(shell);
        Session session = null;
        ChannelShell channel = null;
        InputStream in = null;
        try {
            session = this.createSession(output);
            channel = (ChannelShell)session.openChannel("shell");
            channel.setOutputStream(output, true);
            channel.setExtOutputStream(output, true);
            channel.setPty(Boolean.FALSE.booleanValue());
            in = IOUtils.getInputStreamFromString((String)wrapperShell);
            channel.setInputStream(in, true);
            channel.connect();
            boolean exit = false;
            while (true) {
                BufferedReader br;
                String outputString;
                if (in.available() > 0 && (outputString = (br = new BufferedReader(new InputStreamReader(in))).readLine()) != null) {
                    output.write(outputString.getBytes());
                    if (outputString.indexOf(SSH_BEY_KEY) == -1) continue;
                    exit = true;
                }
                if (exit) break;
            }
            if (logger.isInfoEnabled()) {
                logger.info("##############STOP###############");
            }
            this.closeSession(session, (Channel)channel);
        }
        catch (Exception e) {
            throw new SshException(e);
        }
        finally {
            if (logger.isInfoEnabled()) {
                logger.info("[GSSH]-shell exit status is " + channel.getExitStatus());
            }
            this.closeSession(session, (Channel)channel);
        }
    }

    @Override
    public void executeCommand(OutputStream output, String command) {
        Session session = null;
        ChannelExec channel = null;
        InputStream in = null;
        try {
            String wrapperCommand = this.wrapperInput(command);
            output.write("execute below commands:\n".getBytes());
            output.write(wrapperCommand.getBytes());
            output.flush();
            session = this.createSession(output);
            channel = (ChannelExec)session.openChannel("exec");
            channel.setOutputStream(output, true);
            channel.setExtOutputStream(output, true);
            channel.setPty(Boolean.FALSE.booleanValue());
            channel.setCommand(wrapperCommand);
            channel.connect();
            Thread.sleep(1000L);
            while (true) {
                byte[] buffer = new byte[2048];
                int len = -1;
                in = channel.getInputStream();
                while (-1 != (len = in.read(buffer))) {
                    output.write(buffer, 0, len);
                    output.flush();
                }
                if (channel.isEOF() || !channel.isConnected() || channel.isClosed()) break;
                Thread.sleep(1000L);
            }
            this.closeSession(session, (Channel)channel);
        }
        catch (Exception e) {
            this.closeSession(session, (Channel)channel);
            throw new SshException(e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public String executeSingleCommand(OutputStream out, String command) {
        String s;
        StringBuilder response = new StringBuilder();
        if (logger.isInfoEnabled()) {
            logger.info("execute below commands:");
            logger.info(command);
        }
        Session session = null;
        ChannelExec channel = null;
        InputStream in = null;
        try {
            session = this.createSession(out);
            channel = (ChannelExec)session.openChannel("exec");
            channel.setOutputStream(out, true);
            channel.setExtOutputStream(out, true);
            channel.setPty(Boolean.FALSE.booleanValue());
            channel.setCommand(command);
            in = channel.getInputStream();
            channel.connect();
            Thread.sleep(1000L);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            do {
                char[] buffer = new char[2048];
                int len = -1;
                while (-1 != (len = br.read(buffer))) {
                    response.append(buffer, 0, len);
                }
            } while (!channel.isClosed());
            this.closeSession(session, (Channel)channel);
            s = response.toString();
        }
        catch (Exception e) {
            logger.error("[GSSH]-cmd Exception:" + e.getMessage(), (Throwable)e);
            this.closeSession(session, (Channel)channel);
            throw new SshException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioexception) {}
            }
        }
        return s;
    }

    @Override
    public boolean testConnection(OutputStream output) {
        try {
            Session session = this.createSession(output);
            this.closeSession(session, null);
            return true;
        }
        catch (Exception e) {
            logger.error("test ssh connection failed !", (Throwable)e);
            return false;
        }
    }

    private void closeSession(Session session, Channel channel) {
        if (channel != null) {
            channel.disconnect();
            channel = null;
        }
        if (session != null) {
            session.disconnect();
            session = null;
        }
    }

    protected String wrapperInput(String input) {
        if (!this.needSource) {
            return input;
        }
        String output = this.fixIEIssue(input);
        return SSH_PROFILE + output + SSH_BEY;
    }

    private String fixIEIssue(String input) {
        return StringEscapeUtils.unescapeHtml((String)input);
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isNeedSource() {
        return this.needSource;
    }

    public void setNeedSource(boolean needSource) {
        this.needSource = needSource;
    }

    public String toString() {
        return "Server Info [" + this.ip + " ," + this.port + "," + this.username + "," + this.password + "]";
    }
}

