/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.openbox.server.ssh;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LinuxClient {
    private static final Logger logger = LogManager.getLogger();
    private String ip;
    private int port;
    private String username;
    private String password;
    private Connection conn;

    public LinuxClient(String ip, int port, String username, String password) {
        this.ip = ip;
        this.port = port;
        this.username = username;
        this.password = password;
        this.initConnection();
    }

    public static LinuxClient newInstance(String ip, int port, String username, String password) {
        return new LinuxClient(ip, port, username, password);
    }

    private void initConnection() {
        try {
            this.conn = new Connection(this.ip, this.port);
            this.conn.connect();
            boolean isAuthenticated = this.conn.authenticateWithPassword(this.username, this.password);
            if (!isAuthenticated) {
                throw new IOException("Authentication failed.");
            }
            if (logger.isInfoEnabled()) {
                logger.info("\nssh login success to ip=[" + this.ip + "],port=[" + this.port + "],username=[" + this.username + "],password=[*******]");
            }
        }
        catch (Exception e) {
            String msg = "\nSSH Connection and Login error to ip=[" + this.ip + "],port=[" + this.port + "],username=[" + this.username + "],password=[*******]";
            logger.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    private Session getSession() {
        try {
            Session session = this.conn.openSession();
            session.requestPTY("dumb");
            session.startShell();
            return session;
        }
        catch (Exception e) {
            String msg = "\nOpen SSH2 Session Error !";
            logger.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    public String executeCommand(String command) {
        String response = null;
        Session session = this.getSession();
        PrintWriter out = new PrintWriter(session.getStdin());
        try {
            ExecutorService exec = Executors.newSingleThreadExecutor();
            Future<String> task = exec.submit(new SshTask(session));
            String[] commands = command.split("\n");
            for (int i = 0; i < commands.length; ++i) {
                String cmd = commands[i];
                if ("".equals(cmd.trim())) continue;
                out.println(cmd);
            }
            out.println("exit 0");
            out.println("exit 0");
            out.close();
            response = task.get();
            exec.shutdown();
            exec.awaitTermination(2L, TimeUnit.DAYS);
            if (logger.isInfoEnabled()) {
                logger.info("exit status -->" + session.getExitStatus());
            }
        }
        catch (Exception e) {
            String msg = "execute commd=[" + command + "]failed !";
            throw new RuntimeException(msg, e);
        }
        finally {
            out.close();
            session.close();
        }
        return response;
    }

    public void close() {
        if (null != this.conn) {
            this.conn.close();
        }
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    private class SshTask
    implements Callable<String> {
        private Session session;

        public String execute() throws IOException, InterruptedException {
            InputStream stdout = this.session.getStdout();
            InputStream stderr = this.session.getStderr();
            char[] buffer = new char[2048];
            BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(stdout));
            BufferedReader stderrReader = new BufferedReader(new InputStreamReader(stderr));
            StringBuilder sb = new StringBuilder();
            block0: while (true) {
                if (stdout.available() == 0 && stderr.available() == 0) {
                    int conditions = this.session.waitForCondition(44, 600000L);
                    if ((conditions & 1) != 0) {
                        if (!logger.isInfoEnabled()) break;
                        logger.info("wait timeout and exit now !");
                        break;
                    }
                    if ((conditions & 0x20) != 0) break;
                }
                int len = -1;
                do {
                    if ((len = stdoutReader.read(buffer)) <= 0) continue;
                    sb.append(buffer, 0, len);
                } while (-1 != len);
                int errLen = -1;
                while (true) {
                    if (-1 == (errLen = stderrReader.read(buffer))) continue block0;
                    if (errLen <= 0) continue;
                    sb.append(buffer, 0, errLen);
                }
                break;
            }
            stdout.close();
            stderr.close();
            String response = sb.toString();
            if (logger.isInfoEnabled()) {
                logger.info("\n" + response);
            }
            return response;
        }

        @Override
        public String call() throws Exception {
            return this.execute();
        }

        public SshTask(Session session) {
            this.session = session;
        }
    }
}

