/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.redbox.plugins.curation.redbox;

import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.PluginManager;
import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.indexer.SearchRequest;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.api.transaction.TransactionException;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.solr.SolrDoc;
import com.googlecode.fascinator.common.solr.SolrResult;
import com.googlecode.fascinator.common.transaction.GenericTransactionManager;
import com.googlecode.fascinator.messaging.TransactionManagerQueueConsumer;
import com.googlecode.fascinator.redbox.plugins.curation.redbox.FormDataParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.json.simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurationManager
extends GenericTransactionManager {
    private static String DATA_PAYLOAD_SUFFIX = ".tfpackage";
    private static String WORKFLOW_PAYLOAD = "workflow.metadata";
    private static String READY_PROPERTY = "ready_to_publish";
    private static String PUBLISH_PROPERTY = "published";
    private static Logger log = LoggerFactory.getLogger(CurationManager.class);
    private JsonSimpleConfig systemConfig;
    private Storage storage;
    private Indexer indexer;
    private String urlBase;
    private String emailAddress;
    private String pidProperty;
    private boolean manualConfirmation;
    private String brokerUrl;
    private String mintBroker;
    private Map<String, JsonSimple> relationFields;

    public CurationManager() {
        super("curation-redbox", "ReDBox Curation Transaction Manager");
    }

    public void init() throws TransactionException {
        this.systemConfig = this.getJsonConfig();
        String storageId = this.systemConfig.getString("file-system", new Object[]{"storage", "type"});
        if (storageId == null) {
            throw new TransactionException("No Storage ID provided");
        }
        this.storage = PluginManager.getStorage((String)storageId);
        if (this.storage == null) {
            throw new TransactionException("Unable to load Storage '" + storageId + "'");
        }
        try {
            this.storage.init(this.systemConfig.toString());
        }
        catch (PluginException ex) {
            log.error("Unable to initialise storage layer!", (Throwable)ex);
            throw new TransactionException((Throwable)ex);
        }
        String indexerId = this.systemConfig.getString("solr", new Object[]{"indexer", "type"});
        if (indexerId == null) {
            throw new TransactionException("No Indexer ID provided");
        }
        this.indexer = PluginManager.getIndexer((String)indexerId);
        if (this.indexer == null) {
            throw new TransactionException("Unable to load Indexer '" + indexerId + "'");
        }
        try {
            this.indexer.init(this.systemConfig.toString());
        }
        catch (PluginException ex) {
            log.error("Unable to initialise indexer!", (Throwable)ex);
            throw new TransactionException((Throwable)ex);
        }
        this.urlBase = this.systemConfig.getString(null, new Object[]{"urlBase"});
        if (this.urlBase == null) {
            throw new TransactionException("URL Base in config cannot be null");
        }
        this.emailAddress = this.systemConfig.getString(null, new Object[]{"curation", "curationEmailAddress"});
        if (this.emailAddress == null) {
            throw new TransactionException("An admin email is required!");
        }
        this.pidProperty = this.systemConfig.getString(null, new Object[]{"curation", "pidProperty"});
        if (this.pidProperty == null) {
            throw new TransactionException("An admin email is required!");
        }
        this.manualConfirmation = this.systemConfig.getBoolean(Boolean.valueOf(false), new Object[]{"curation", "curationRequiresConfirmation"});
        this.brokerUrl = this.systemConfig.getString(null, new Object[]{"messaging", "url"});
        if (this.brokerUrl == null) {
            throw new TransactionException("Cannot find the message broker.");
        }
        this.mintBroker = this.systemConfig.getString(null, new Object[]{"curation", "mintBroker"});
        if (this.mintBroker == null) {
            throw new TransactionException("Cannot find Mint's message broker.");
        }
        this.relationFields = this.systemConfig.getJsonSimpleMap(new Object[]{"curation", "relations"});
        if (this.relationFields == null) {
            log.warn("Curation configuration has no relationships");
            this.relationFields = new HashMap<String, JsonSimple>();
        }
    }

    public void shutdown() throws PluginException {
        if (this.storage != null) {
            try {
                this.storage.shutdown();
            }
            catch (PluginException pe) {
                log.error("Failed to shutdown storage: {}", (Object)pe.getMessage());
                throw pe;
            }
        }
        if (this.indexer != null) {
            try {
                this.indexer.shutdown();
            }
            catch (PluginException pe) {
                log.error("Failed to shutdown indexer: {}", (Object)pe.getMessage());
                throw pe;
            }
        }
    }

    private void workflowCuration(JsonSimple response, JsonSimple message) {
        String oid = message.getString(null, new Object[]{"oid"});
        if (!this.workflowCompleted(oid)) {
            return;
        }
        try {
            JSONArray relations = this.mapRelations(oid);
            if (relations != null) {
                JsonObject request = this.createTask(response, oid, "curation-request");
                if (!relations.isEmpty()) {
                    request.put((Object)"relationships", (Object)relations);
                }
            }
        }
        catch (Exception ex) {
            log.error("Error processing relations: ", (Throwable)ex);
            return;
        }
    }

    private boolean workflowCompleted(String oid) {
        JsonSimple workflow = this.getWorkflowData(oid);
        if (workflow == null) {
            log.error("Error accessing workflow data '{}'", (Object)oid);
            return false;
        }
        String step = workflow.getString(null, new Object[]{"step"});
        if (step == null || !step.equals("live")) {
            log.debug("Workflow step '{}', ignoring.", (Object)step);
            return false;
        }
        return true;
    }

    private JSONArray mapRelations(String oid) {
        JsonSimple formData = this.parsedFormData(oid);
        if (formData == null) {
            log.error("Error parsing form data");
            return null;
        }
        JsonSimple rawData = this.getDataFromStorage(oid);
        if (rawData == null) {
            log.error("Error reading data from storage");
            return null;
        }
        JSONArray relations = rawData.writeArray(new Object[]{"relationships"});
        boolean changed = false;
        for (String baseField : this.relationFields.keySet()) {
            JsonObject newRelation;
            JsonSimple relationConfig = this.relationFields.get(baseField);
            List basePath = relationConfig.getStringList(new Object[]{"path"});
            if (basePath == null || basePath.isEmpty()) {
                log.error("Ignoring invalid relationship '{}'. No 'path' provided in configuration", (Object)baseField);
                continue;
            }
            Object object = formData.getPath(basePath.toArray());
            if (object instanceof JsonObject && (newRelation = this.lookForRelation(oid, baseField, relationConfig, new JsonSimple((JsonObject)object))) != null && !this.isKnownRelation(relations, newRelation)) {
                log.info("Adding relation: '{}' => '{}'", (Object)baseField, newRelation.get((Object)"identifier"));
                relations.add((Object)newRelation);
                changed = true;
            }
            if (!(object instanceof JSONArray)) continue;
            for (Object loopObject : (JSONArray)object) {
                JsonObject newRelation2;
                if (!(loopObject instanceof JsonObject) || (newRelation2 = this.lookForRelation(oid, baseField, relationConfig, new JsonSimple((JsonObject)loopObject))) == null || this.isKnownRelation(relations, newRelation2)) continue;
                log.info("Adding relation: '{}' => '{}'", (Object)baseField, newRelation2.get((Object)"identifier"));
                relations.add((Object)newRelation2);
                changed = true;
            }
        }
        if (changed) {
            try {
                this.saveObjectData(rawData, oid);
            }
            catch (TransactionException ex) {
                log.error("Error updating object '{}' in storage: ", (Object)oid, (Object)ex);
                return null;
            }
        }
        return relations;
    }

    private JsonObject lookForRelation(String oid, String field, JsonSimple config, JsonSimple baseNode) {
        String system;
        String value;
        String value2;
        JsonObject newRelation = new JsonObject();
        newRelation.put((Object)"field", (Object)field);
        newRelation.put((Object)"authority", (Object)true);
        List exPath = config.getStringList(new Object[]{"excludeCondition", "path"});
        String exValue = config.getString(null, new Object[]{"excludeCondition", "value"});
        if (exPath != null && !exPath.isEmpty() && exValue != null && (value2 = baseNode.getString(null, exPath.toArray())) != null && value2.equals(exValue)) {
            log.info("Excluding relationship '{}' based on config", (Object)field);
            return null;
        }
        String exStartsWith = config.getString(null, new Object[]{"excludeCondition", "startsWith"});
        if (exPath != null && !exPath.isEmpty() && exStartsWith != null && (value = baseNode.getString(null, exPath.toArray())) != null && value.startsWith(exStartsWith)) {
            log.info("Excluding relationship '{}' based on config", (Object)field);
            return null;
        }
        List idPath = config.getStringList(new Object[]{"identifier"});
        if (idPath == null || idPath.isEmpty()) {
            log.error("Ignoring invalid relationship '{}'. No 'identifier' provided in configuration", (Object)field);
            return null;
        }
        String id = baseNode.getString(null, idPath.toArray());
        if (id == null || id.equals("")) {
            log.info("Relationship '{}' has no identifier, ignoring!", (Object)field);
            return null;
        }
        newRelation.put((Object)"identifier", (Object)id);
        String staticRelation = config.getString(null, new Object[]{"relationship"});
        List relPath = null;
        if (staticRelation == null) {
            relPath = config.getStringList(new Object[]{"relationship"});
        }
        if (staticRelation == null && (relPath == null || relPath.isEmpty())) {
            log.error("Ignoring invalid relationship '{}'. No relationship String of path in configuration", (Object)field);
            return null;
        }
        String relString = null;
        relString = staticRelation != null ? staticRelation : baseNode.getString("hasAssociationWith", relPath.toArray());
        if (relString == null || relString.equals("")) {
            log.info("Relationship '{}' has no type, ignoring!", (Object)field);
            return null;
        }
        newRelation.put((Object)"relationship", (Object)relString);
        String revRelation = this.systemConfig.getString("hasAssociationWith", new Object[]{"curation", "reverseMappings", relString});
        newRelation.put((Object)"reverseRelationship", (Object)revRelation);
        String description = config.getString(null, new Object[]{"description"});
        if (description != null) {
            newRelation.put((Object)"description", (Object)description);
        }
        if ((system = config.getString("mint", new Object[]{"system"})) != null && system.equals("mint")) {
            newRelation.put((Object)"broker", (Object)this.mintBroker);
        } else {
            newRelation.put((Object)"broker", (Object)this.brokerUrl);
            newRelation.put((Object)"oid", (Object)id);
        }
        boolean optional = config.getBoolean(Boolean.valueOf(false), new Object[]{"optional"});
        if (optional) {
            newRelation.put((Object)"optional", (Object)optional);
        }
        return newRelation;
    }

    private boolean isKnownRelation(JSONArray relations, JsonObject newRelation) {
        if (newRelation.containsKey((Object)"oid")) {
            for (Object relation : relations) {
                String newOid;
                JsonObject json = (JsonObject)relation;
                String knownOid = (String)json.get((Object)"oid");
                if (!knownOid.equals(newOid = (String)newRelation.get((Object)"oid"))) continue;
                log.debug("Known ReDBox linkage '{}'", (Object)knownOid);
                return true;
            }
            return false;
        }
        for (Object relation : relations) {
            JsonObject json = (JsonObject)relation;
            if (!json.containsKey((Object)"identifier")) continue;
            String knownId = (String)json.get((Object)"identifier");
            String knownField = (String)json.get((Object)"field");
            String newId = (String)newRelation.get((Object)"identifier");
            String newField = (String)newRelation.get((Object)"field");
            if (!knownId.equals(newId) || !knownField.equals(newField)) continue;
            return true;
        }
        return false;
    }

    private JsonSimple curation(JsonSimple message, String task, String oid) {
        DigitalObject object;
        JsonSimple response = new JsonSimple();
        JsonSimple itemConfig = this.getConfigFromStorage(oid);
        if (itemConfig == null) {
            log.error("Error accessing item configuration!");
            return new JsonSimple();
        }
        Properties metadata = this.getObjectMetadata(oid);
        if (metadata == null) {
            log.error("Error accessing item metadata!");
            return new JsonSimple();
        }
        JsonSimple data = this.getDataFromStorage(oid);
        if (data == null) {
            log.error("Error accessing item data!");
            return new JsonSimple();
        }
        boolean curated = false;
        boolean alreadyCurated = itemConfig.getBoolean(Boolean.valueOf(false), new Object[]{"curation", "alreadyCurated"});
        boolean errors = false;
        String thisPid = null;
        if (metadata.containsKey(this.pidProperty)) {
            curated = true;
            thisPid = metadata.getProperty(this.pidProperty);
        } else if (alreadyCurated) {
            String id = data.getString(null, new Object[]{"metadata", "dc.identifier"});
            if (id == null) {
                log.error("Item claims to be curated, but has no 'dc.identifier': '{}'", (Object)oid);
                errors = true;
            } else {
                try {
                    log.info("Update object properties with ingested ID: '{}'", (Object)oid);
                    object = this.storage.getObject(oid);
                    metadata = object.getMetadata();
                    metadata.setProperty(this.pidProperty, id);
                    object.close();
                    metadata = this.getObjectMetadata(oid);
                    curated = true;
                    this.audit(response, oid, "Persitent ID set in properties");
                }
                catch (StorageException ex) {
                    log.error("Error accessing object '{}' in storage: ", (Object)oid, (Object)ex);
                    errors = true;
                }
            }
        }
        if (errors) {
            this.emailObjectLink(response, oid, "An error occurred curating this object, some manual intervention may be required; please see the system logs.");
            this.audit(response, oid, "Errors during curation; aborted.");
            return response;
        }
        if (curated) {
            JsonObject taskObj;
            if (task.equals("curation-response")) {
                log.info("Confirmation of curated object '{}'.", (Object)oid);
                JSONArray responses = data.writeArray(new Object[]{"responses"});
                for (Object thisResponse : responses) {
                    JsonSimple json = new JsonSimple((JsonObject)thisResponse);
                    String broker = json.getString(this.brokerUrl, new Object[]{"broker"});
                    String responseOid = json.getString(null, new Object[]{"oid"});
                    String responseTask = json.getString(null, new Object[]{"task"});
                    JsonObject responseObj = this.createTask(response, broker, responseOid, responseTask);
                    responseObj.put((Object)"originOid", (Object)oid);
                    responseObj.put((Object)"curatedPid", (Object)thisPid);
                }
                if (!metadata.containsKey(READY_PROPERTY)) {
                    try {
                        object = this.storage.getObject(oid);
                        metadata = object.getMetadata();
                        metadata.setProperty(READY_PROPERTY, "ready");
                        object.close();
                        metadata = this.getObjectMetadata(oid);
                        this.audit(response, oid, "This object is ready for publication");
                    }
                    catch (StorageException ex) {
                        log.error("Error accessing object '{}' in storage: ", (Object)oid, (Object)ex);
                        this.emailObjectLink(response, oid, "This object is ready for publication, but an error occured writing to storage. Please see the system log");
                    }
                    this.emailObjectLink(response, oid, "This email is confirming that the object linked below has completed curation.");
                    this.audit(response, oid, "Curation completed.");
                    this.createTask(response, oid, "reharvest");
                    this.createTask(response, oid, "publish");
                } else {
                    this.createTask(response, oid, "publish");
                }
                return response;
            }
            if (task.equals("curation-pending")) {
                String childOid = message.getString(null, new Object[]{"originOid"});
                String childId = message.getString(null, new Object[]{"originId"});
                String curatedPid = message.getString(null, new Object[]{"curatedPid"});
                boolean isReady = false;
                try {
                    isReady = this.checkChildren(response, data, oid, thisPid, false, childOid, childId, curatedPid);
                }
                catch (TransactionException ex) {
                    log.error("Error updating related objects '{}': ", (Object)oid, (Object)ex);
                    this.emailObjectLink(response, oid, "An error occurred curating this object, some manual intervention may be required; please see the system logs.");
                    this.audit(response, oid, "Errors curating relations; aborted.");
                    return response;
                }
                if (isReady) {
                    this.createTask(response, oid, "curation-response");
                }
                return response;
            }
            if (task.equals("curation-confirm")) {
                boolean isReady = false;
                try {
                    isReady = this.checkChildren(response, data, oid, thisPid, true);
                }
                catch (TransactionException ex) {
                    log.error("Error processing related objects '{}': ", (Object)oid, (Object)ex);
                    this.emailObjectLink(response, oid, "An error occurred curating this object, some manual intervention may be required; please see the system logs.");
                    this.audit(response, oid, "Errors curating relations; aborted.");
                    return response;
                }
                if (isReady) {
                    this.createTask(response, oid, "curation-response");
                } else {
                    this.audit(response, oid, "Curation complete, but still waiting on relations.");
                }
                return response;
            }
            if (task.equals("curation-request") || task.equals("curation-query")) {
                try {
                    this.storeRequestData(message, oid);
                }
                catch (TransactionException ex) {
                    log.error("Error storing request data '{}': ", (Object)oid, (Object)ex);
                    this.emailObjectLink(response, oid, "An error occurred curating this object, some manual intervention may be required; please see the system logs.");
                    this.audit(response, oid, "Errors during curation; aborted.");
                    return response;
                }
                if (task.equals("curation-request")) {
                    taskObj = this.createTask(response, oid, "curation");
                    taskObj.put((Object)"alreadyCurated", (Object)true);
                } else {
                    JsonSimple respond = new JsonSimple(message.getObject(new Object[]{"respond"}));
                    String broker = respond.getString(this.brokerUrl, new Object[]{"broker"});
                    String responseOid = respond.getString(null, new Object[]{"oid"});
                    String responseTask = respond.getString(null, new Object[]{"task"});
                    JsonObject responseObj = this.createTask(response, broker, responseOid, responseTask);
                    responseObj.put((Object)"originOid", (Object)oid);
                    responseObj.put((Object)"curatedPid", (Object)thisPid);
                }
                return response;
            }
            if (task.equals("curation")) {
                log.info("Request to curate ignored. This object '{}' has already been curated.", (Object)oid);
                taskObj = this.createTask(response, oid, "curation-confirm");
                taskObj.put((Object)"alreadyCurated", (Object)true);
                return response;
            }
        } else {
            if (task.equals("curation-confirm") || task.equals("curation-pending")) {
                this.emailObjectLink(response, oid, "NOTICE: The system has received a '" + task + "'" + " event, but the record does not appear to be" + " curated. If your system is configured for VITAL" + " integration this should clear by itself soon.");
                return response;
            }
            if (task.equals("curation-request")) {
                try {
                    this.storeRequestData(message, oid);
                }
                catch (TransactionException ex) {
                    log.error("Error storing request data '{}': ", (Object)oid, (Object)ex);
                    this.emailObjectLink(response, oid, "An error occurred curating this object, some manual intervention may be required; please see the system logs.");
                    this.audit(response, oid, "Errors during curation; aborted.");
                    return response;
                }
                if (!this.workflowCompleted(oid)) {
                    log.warn("Curation request recieved, but object has not finished workflow.");
                    return response;
                }
                if (this.manualConfirmation) {
                    this.emailObjectLink(response, oid, "A curation request has been recieved for this object. You can find a link below to approve the request.");
                    this.audit(response, oid, "Curation request received. Pending");
                } else {
                    this.createTask(response, oid, "curation");
                }
                return response;
            }
            if (task.equals("curation-query")) {
                try {
                    this.storeRequestData(message, oid);
                }
                catch (TransactionException ex) {
                    log.error("Error storing request data '{}': ", (Object)oid, (Object)ex);
                    this.emailObjectLink(response, oid, "An error occurred curating this object, some manual intervention may be required; please see the system logs.");
                    this.audit(response, oid, "Errors during curation; aborted.");
                    return response;
                }
                return response;
            }
            if (task.equals("curation")) {
                this.audit(response, oid, "Object curation requested.");
                List list = itemConfig.getStringList(new Object[]{"transformer", "curation"});
                if (list != null && !list.isEmpty()) {
                    for (String id : list) {
                        JsonObject order = this.newTransform(response, id, oid);
                        JsonObject config = (JsonObject)order.get((Object)"config");
                        JsonObject overrides = itemConfig.getObject(new Object[]{"transformerOverrides", id});
                        if (overrides == null) continue;
                        config.putAll((Map)overrides);
                    }
                } else {
                    log.warn("This object has no configured transformers!");
                }
                JsonObject order = this.newIndex(response, oid);
                order.put((Object)"forceCommit", (Object)true);
                this.createTask(response, oid, "curation-confirm");
                return response;
            }
        }
        log.error("Invalid message received. Unknown task:\n{}", (Object)message.toString(true));
        this.emailObjectLink(response, oid, "The curation manager has received an invalid curation message for this object. Please see the system logs.");
        return response;
    }

    private boolean checkChildren(JsonSimple response, JsonSimple data, String thisOid, String thisPid, boolean sendRequests) throws TransactionException {
        return this.checkChildren(response, data, thisOid, thisPid, sendRequests, null, null, null);
    }

    private boolean checkChildren(JsonSimple response, JsonSimple data, String thisOid, String thisPid, boolean sendRequests, String childOid, String childId, String curatedPid) throws TransactionException {
        boolean isReady = true;
        boolean saveData = false;
        log.debug("Checking Children of '{}'", (Object)thisOid);
        JSONArray relations = data.writeArray(new Object[]{"relationships"});
        for (Object relation : relations) {
            boolean isCurated;
            boolean updatingByOid;
            JsonSimple json = new JsonSimple((JsonObject)relation);
            String broker = json.getString(this.brokerUrl, new Object[]{"broker"});
            boolean localRecord = broker.equals(this.brokerUrl);
            String relatedId = json.getString(null, new Object[]{"identifier"});
            String relatedOid = json.getString(null, new Object[]{"oid"});
            if (relatedOid == null && localRecord) {
                String identifier = json.getString(null, new Object[]{"identifier"});
                if (identifier == null) {
                    throw new TransactionException("NULL identifer provided!");
                }
                relatedOid = this.idToOid(identifier);
                if (relatedOid == null) {
                    throw new TransactionException("Cannot resolve identifer: " + identifier);
                }
                ((JsonObject)relation).put((Object)"oid", (Object)relatedOid);
                saveData = true;
            }
            boolean updatingById = childId != null && childId.equals(relatedId);
            boolean bl = updatingByOid = childOid != null && childOid.equals(relatedOid);
            if (curatedPid != null && (updatingById || updatingByOid)) {
                log.debug("Updating...");
                ((JsonObject)relation).put((Object)"isCurated", (Object)true);
                ((JsonObject)relation).put((Object)"curatedPid", (Object)curatedPid);
                saveData = true;
            }
            if (!(isCurated = json.getBoolean(Boolean.valueOf(false), new Object[]{"isCurated"}).booleanValue())) {
                JsonObject task;
                log.debug(" * Needs curation '{}'", (Object)relatedId);
                boolean optional = json.getBoolean(Boolean.valueOf(false), new Object[]{"optional"});
                if (!optional) {
                    isReady = false;
                }
                if (!sendRequests) continue;
                if (localRecord) {
                    task = this.createTask(response, relatedOid, "curation-query");
                } else {
                    task = this.createTask(response, broker, relatedOid, "curation-query");
                    task.remove((Object)"oid");
                    task.put((Object)"identifier", (Object)relatedId);
                }
                boolean authority = json.getBoolean(Boolean.valueOf(false), new Object[]{"authority"});
                if (authority) {
                    task.put((Object)"task", (Object)"curation-request");
                    String reverseRelationship = json.getString("hasAssociationWith", new Object[]{"reverseRelationship"});
                    JsonObject relObject = new JsonObject();
                    relObject.put((Object)"identifier", (Object)thisPid);
                    relObject.put((Object)"curatedPid", (Object)thisPid);
                    relObject.put((Object)"broker", (Object)this.brokerUrl);
                    relObject.put((Object)"isCurated", (Object)true);
                    relObject.put((Object)"relationship", (Object)reverseRelationship);
                    if (localRecord) {
                        relObject.put((Object)"oid", (Object)thisOid);
                    }
                    JSONArray newRelations = new JSONArray();
                    newRelations.add((Object)relObject);
                    task.put((Object)"relationships", (Object)newRelations);
                }
                JsonObject msgResponse = new JsonObject();
                msgResponse.put((Object)"broker", (Object)this.brokerUrl);
                msgResponse.put((Object)"oid", (Object)thisOid);
                msgResponse.put((Object)"task", (Object)"curation-pending");
                task.put((Object)"respond", (Object)msgResponse);
                continue;
            }
            log.debug(" * Already curated '{}'", (Object)relatedId);
        }
        if (saveData) {
            this.saveObjectData(data, thisOid);
        }
        return isReady;
    }

    private String idToOid(String identifier) {
        String query = "known_ids:\"" + identifier + "\"";
        SearchRequest request = new SearchRequest(query);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SolrResult result = null;
        try {
            this.indexer.search(request, (OutputStream)out);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            result = new SolrResult((InputStream)in);
        }
        catch (Exception ex) {
            log.error("Error searching Solr: ", (Throwable)ex);
            return null;
        }
        if (result.getNumFound() == 0) {
            log.error("Cannot resolve ID '{}'", (Object)identifier);
            return null;
        }
        if (result.getNumFound() > 1) {
            log.error("Found multiple OIDs for ID '{}'", (Object)identifier);
            return null;
        }
        SolrDoc doc = (SolrDoc)result.getResults().get(0);
        return doc.getFirst("storage_id");
    }

    private void storeRequestData(JsonSimple message, String oid) throws TransactionException {
        JsonObject toRespond = message.getObject(new Object[]{"respond"});
        JSONArray newRelations = message.getArray(new Object[]{"relationships"});
        if (toRespond == null && newRelations == null) {
            log.warn("This request requires no responses and specifies no relationships.");
            return;
        }
        DigitalObject object = null;
        Payload payload = null;
        InputStream inStream = null;
        try {
            object = this.storage.getObject(oid);
            payload = this.getDataPayload(object);
            inStream = payload.open();
        }
        catch (StorageException ex) {
            log.error("Error accessing object '{}' in storage: ", (Object)oid, (Object)ex);
            throw new TransactionException((Throwable)ex);
        }
        JsonSimple metadata = null;
        try {
            metadata = new JsonSimple(inStream);
            inStream.close();
        }
        catch (IOException ex) {
            log.error("Error parsing/reading JSON '{}'", (Object)oid, (Object)ex);
            throw new TransactionException((Throwable)ex);
        }
        if (toRespond != null) {
            JSONArray responses = metadata.writeArray(new Object[]{"responses"});
            boolean duplicate = false;
            String newOid = (String)toRespond.get((Object)"oid");
            for (Object response : responses) {
                String oldOid = (String)((JsonObject)response).get((Object)"oid");
                if (!newOid.equals(oldOid)) continue;
                log.debug("Ignoring duplicate response request by '{}' on object '{}'", (Object)newOid, (Object)oid);
                duplicate = true;
            }
            if (!duplicate) {
                log.debug("New response requested by '{}' on object '{}'", (Object)newOid, (Object)oid);
                responses.add((Object)toRespond);
            }
        }
        if (newRelations != null) {
            JSONArray relations = metadata.writeArray(new Object[]{"relationships"});
            for (JsonSimple newRelation : JsonSimple.toJavaList((JSONArray)newRelations)) {
                boolean duplicate = false;
                String identifier = newRelation.getString(null, new Object[]{"identifier"});
                for (JsonSimple relation : JsonSimple.toJavaList((JSONArray)relations)) {
                    String storedId = relation.getString(null, new Object[]{"identifier"});
                    if (!identifier.equals(storedId)) continue;
                    log.debug("Ignoring duplicate relationship '{}'", (Object)identifier);
                    duplicate = true;
                }
                if (duplicate) continue;
                log.debug("New relationship added to '{}'", (Object)oid);
                relations.add((Object)newRelation.getJsonObject());
            }
        }
        if (toRespond != null || newRelations != null) {
            log.info("Updating object in storage '{}'", (Object)oid);
            String jsonString = metadata.toString(true);
            try {
                this.updateDataPayload(object, jsonString);
            }
            catch (Exception ex) {
                log.error("Unable to store data '{}': ", (Object)oid, (Object)ex);
                throw new TransactionException((Throwable)ex);
            }
        }
    }

    private JsonSimple publish(JsonSimple message, String oid) throws TransactionException {
        log.debug("Publishing '{}'", (Object)oid);
        JsonSimple response = new JsonSimple();
        try {
            DigitalObject object = this.storage.getObject(oid);
            Properties metadata = object.getMetadata();
            if (!metadata.containsKey(PUBLISH_PROPERTY)) {
                metadata.setProperty(PUBLISH_PROPERTY, "true");
                object.close();
                log.info("Publication flag set '{}'", (Object)oid);
                this.audit(response, oid, "Publication flag set");
            } else {
                log.info("Publication flag is already set '{}'", (Object)oid);
            }
        }
        catch (StorageException ex) {
            throw new TransactionException("Error setting publish property: ", (Throwable)ex);
        }
        JsonSimple itemConfig = this.getConfigFromStorage(oid);
        if (itemConfig == null) {
            log.error("Error accessing item configuration!");
        } else {
            List list = itemConfig.getStringList(new Object[]{"transformer", "curation"});
            if (list != null && !list.isEmpty()) {
                for (String id : list) {
                    JsonObject order = this.newTransform(response, id, oid);
                    JsonObject config = (JsonObject)order.get((Object)"config");
                    JsonObject overrides = itemConfig.getObject(new Object[]{"transformerOverrides", id});
                    if (overrides == null) continue;
                    config.putAll((Map)overrides);
                }
            }
        }
        this.publishRelations(response, oid);
        return response;
    }

    private void publishRelations(JsonSimple response, String oid) {
        log.debug("Publishing Children of '{}'", (Object)oid);
        JsonSimple data = this.getDataFromStorage(oid);
        if (data == null) {
            log.error("Error accessing item data! '{}'", (Object)oid);
            this.emailObjectLink(response, oid, "An error occured publishing the related objects for this record. Please check the system logs.");
            return;
        }
        JSONArray relations = data.writeArray(new Object[]{"relationships"});
        for (Object relation : relations) {
            boolean authority;
            JsonSimple json = new JsonSimple((JsonObject)relation);
            String broker = json.getString(null, new Object[]{"broker"});
            boolean localRecord = broker.equals(this.brokerUrl);
            String relatedId = json.getString(null, new Object[]{"identifier"});
            String relatedOid = json.getString(null, new Object[]{"oid"});
            if (relatedOid == null && localRecord) {
                String identifier = json.getString(null, new Object[]{"identifier"});
                if (identifier == null) {
                    log.error("NULL identifer provided!");
                }
                if ((relatedOid = this.idToOid(identifier)) == null) {
                    log.error("Cannot resolve identifer: '{}'", (Object)identifier);
                }
            }
            if (!(authority = json.getBoolean(Boolean.valueOf(false), new Object[]{"authority"}).booleanValue())) continue;
            boolean isCurated = json.getBoolean(Boolean.valueOf(false), new Object[]{"isCurated"});
            if (isCurated) {
                log.debug(" * Publishing '{}'", (Object)relatedId);
                if (localRecord) {
                    this.createTask(response, relatedOid, "publish");
                    continue;
                }
                JsonObject task = this.createTask(response, broker, relatedOid, "publish");
                task.remove((Object)"oid");
                task.put((Object)"identifier", (Object)relatedId);
                continue;
            }
            log.debug(" * Ignoring non-curated relationship '{}'", (Object)relatedId);
        }
    }

    public JsonSimple parseMessage(JsonSimple message) throws TransactionException {
        log.debug("\n{}", (Object)message.toString(true));
        JsonObject harvester = message.getObject(new Object[]{"harvester"});
        if (harvester != null) {
            try {
                String oid = message.getString(null, new Object[]{"oid"});
                JsonSimple response = new JsonSimple();
                this.audit(response, oid, "Tool Chain");
                this.scheduleTransformers(message, response);
                JsonObject order = this.newIndex(response, oid);
                order.put((Object)"forceCommit", (Object)true);
                this.createTask(response, oid, "clear-render-flag");
                return response;
            }
            catch (Exception ex) {
                throw new TransactionException((Throwable)ex);
            }
        }
        String task = message.getString(null, new Object[]{"task"});
        if (task != null) {
            String oid = message.getString(null, new Object[]{"oid"});
            if (task.equals("workflow-curation")) {
                JsonSimple response = new JsonSimple();
                this.workflowCuration(response, message);
                return response;
            }
            if (task.equals("workflow")) {
                JsonSimple response = new JsonSimple();
                String eventType = message.getString(null, new Object[]{"eventType"});
                String newStep = message.getString(null, new Object[]{"newStep"});
                if (newStep != null || eventType.equals("ReIndex")) {
                    JsonObject order;
                    boolean quickIndex = message.getBoolean(Boolean.valueOf(false), new Object[]{"quickIndex"});
                    if (quickIndex) {
                        order = this.newIndex(response, oid);
                        order.put((Object)"forceCommit", (Object)true);
                    }
                    order = this.newSubscription(response, oid);
                    JsonObject audit = (JsonObject)order.get((Object)"message");
                    audit.putAll((Map)message.getJsonObject());
                    this.reharvest(response, message);
                    this.createTask(response, oid, "workflow-curation");
                } else {
                    JsonObject order = this.newSubscription(response, oid);
                    JsonObject audit = (JsonObject)order.get((Object)"message");
                    audit.putAll((Map)message.getJsonObject());
                }
                return response;
            }
            if (task.equals("reharvest")) {
                JsonSimple response = new JsonSimple();
                this.reharvest(response, message);
                return response;
            }
            if (task.equals("clear-render-flag")) {
                if (oid != null) {
                    this.clearRenderFlag(oid);
                } else {
                    log.error("Cannot clear render flag without an OID!");
                }
            }
            if (task.startsWith("curation")) {
                try {
                    if (oid != null) {
                        JsonSimple response = this.curation(message, task, oid);
                        JsonObject order = this.newIndex(response, oid);
                        order.put((Object)"forceCommit", (Object)true);
                        return response;
                    }
                    log.error("We need an OID to curate!");
                }
                catch (Exception ex) {
                    JsonSimple response = new JsonSimple();
                    log.error("Error during curation: ", (Throwable)ex);
                    this.emailObjectLink(response, oid, "An unknown error occurred curating this object. Please check the system logs.");
                    return response;
                }
            }
            if (task.startsWith("publish")) {
                try {
                    if (oid == null && (oid = this.idToOid(message.getString(null, new Object[]{"identifier"}))) != null) {
                        message.getJsonObject().put((Object)"oid", (Object)oid);
                    }
                    if (oid != null) {
                        JsonSimple response = this.publish(message, oid);
                        this.reharvest(response, message);
                        return response;
                    }
                    log.error("We need an OID to publish!");
                }
                catch (Exception ex) {
                    JsonSimple response = new JsonSimple();
                    log.error("Error during publication: ", (Throwable)ex);
                    this.emailObjectLink(response, oid, "An unknown error occurred publishing this object. Please check the system logs.");
                    return response;
                }
            }
        }
        return new JsonSimple();
    }

    private void reharvest(JsonSimple response, JsonSimple message) {
        String oid = message.getString(null, new Object[]{"oid"});
        try {
            if (oid != null) {
                this.setRenderFlag(oid);
                JsonSimple itemConfig = this.getConfigFromStorage(oid);
                if (itemConfig == null) {
                    log.error("Error accessing item configuration!");
                    return;
                }
                itemConfig.getJsonObject().put((Object)"oid", (Object)oid);
                this.scheduleTransformers(itemConfig, response);
                JsonObject order = this.newIndex(response, oid);
                order.put((Object)"forceCommit", (Object)true);
                this.createTask(response, oid, "clear-render-flag");
            } else {
                log.error("Cannot reharvest without an OID!");
            }
        }
        catch (Exception ex) {
            log.error("Error during reharvest setup: ", (Throwable)ex);
        }
    }

    private void emailObjectLink(JsonSimple response, String oid, String message) {
        String link = this.urlBase + "default/detail/" + oid;
        String text = "This is an automated message from the ";
        text = text + "ReDBox Curation Manager.\n\n" + message;
        text = text + "\n\nYou can find this object here:\n" + link;
        this.email(response, oid, text);
    }

    private void email(JsonSimple response, String oid, String text) {
        JsonObject object = this.newMessage(response, "emailnotification");
        JsonObject message = (JsonObject)object.get((Object)"message");
        message.put((Object)"to", (Object)this.emailAddress);
        message.put((Object)"body", (Object)text);
        message.put((Object)"oid", (Object)oid);
    }

    private void audit(JsonSimple response, String oid, String message) {
        JsonObject order = this.newSubscription(response, oid);
        JsonObject messageObject = (JsonObject)order.get((Object)"message");
        messageObject.put((Object)"eventType", (Object)message);
    }

    private void scheduleTransformers(JsonSimple message, JsonSimple response) {
        String oid = message.getString(null, new Object[]{"oid"});
        List list = message.getStringList(new Object[]{"transformer", "metadata"});
        if (list != null && !list.isEmpty()) {
            for (String id : list) {
                JsonObject order = this.newTransform(response, id, oid);
                JsonObject itemConfig = message.getObject(new Object[]{"transformerOverrides", id});
                if (itemConfig == null) continue;
                JsonObject config = (JsonObject)order.get((Object)"config");
                config.putAll((Map)itemConfig);
            }
        }
    }

    private void clearRenderFlag(String oid) {
        try {
            DigitalObject object = this.storage.getObject(oid);
            Properties props = object.getMetadata();
            props.setProperty("render-pending", "false");
            object.close();
        }
        catch (StorageException ex) {
            log.error("Error accessing storage for '{}'", (Object)oid, (Object)ex);
        }
    }

    private void setRenderFlag(String oid) {
        try {
            DigitalObject object = this.storage.getObject(oid);
            Properties props = object.getMetadata();
            props.setProperty("render-pending", "true");
            object.close();
        }
        catch (StorageException ex) {
            log.error("Error accessing storage for '{}'", (Object)oid, (Object)ex);
        }
    }

    private JsonObject createTask(JsonSimple response, String oid, String task) {
        return this.createTask(response, null, oid, task);
    }

    private JsonObject createTask(JsonSimple response, String broker, String oid, String task) {
        JsonObject object = this.newMessage(response, "transactionManager");
        if (broker != null) {
            object.put((Object)"broker", (Object)broker);
        }
        JsonObject message = (JsonObject)object.get((Object)"message");
        message.put((Object)"task", (Object)task);
        message.put((Object)"oid", (Object)oid);
        return message;
    }

    private JsonObject newIndex(JsonSimple response, String oid) {
        JsonObject order = this.createNewOrder(response, TransactionManagerQueueConsumer.OrderType.INDEXER.toString());
        order.put((Object)"oid", (Object)oid);
        return order;
    }

    private JsonObject newMessage(JsonSimple response, String target) {
        JsonObject order = this.createNewOrder(response, TransactionManagerQueueConsumer.OrderType.MESSAGE.toString());
        order.put((Object)"target", (Object)target);
        order.put((Object)"message", (Object)new JsonObject());
        return order;
    }

    private JsonObject newSubscription(JsonSimple response, String oid) {
        JsonObject order = this.createNewOrder(response, TransactionManagerQueueConsumer.OrderType.SUBSCRIBER.toString());
        order.put((Object)"oid", (Object)oid);
        JsonObject message = new JsonObject();
        message.put((Object)"oid", (Object)oid);
        message.put((Object)"context", (Object)"Curation");
        message.put((Object)"eventType", (Object)"Sending test message");
        message.put((Object)"user", (Object)"system");
        order.put((Object)"message", (Object)message);
        return order;
    }

    private JsonObject newTransform(JsonSimple response, String target, String oid) {
        JsonObject order = this.createNewOrder(response, TransactionManagerQueueConsumer.OrderType.TRANSFORMER.toString());
        order.put((Object)"target", (Object)target);
        order.put((Object)"oid", (Object)oid);
        order.put((Object)"config", (Object)new JsonObject());
        return order;
    }

    private JsonObject createNewOrder(JsonSimple response, String type) {
        JsonObject order = response.writeObject(new Object[]{"orders", -1});
        order.put((Object)"type", (Object)type);
        return order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonSimple getConfigFromStorage(String oid) {
        DigitalObject object;
        String configOid = null;
        String configPid = null;
        try {
            object = this.storage.getObject(oid);
            Properties metadata = object.getMetadata();
            configOid = metadata.getProperty("jsonConfigOid");
            configPid = metadata.getProperty("jsonConfigPid");
        }
        catch (StorageException ex) {
            log.error("Error accessing object '{}' in storage: ", (Object)oid, (Object)ex);
            return null;
        }
        if (configOid == null || configPid == null) {
            log.error("Unable to find configuration for OID '{}'", (Object)oid);
            return null;
        }
        try {
            object = this.storage.getObject(configOid);
            Payload payload = object.getPayload(configPid);
            try {
                JsonSimple jsonSimple = new JsonSimple(payload.open());
                return jsonSimple;
            }
            catch (IOException ex) {
                log.error("Error accessing config '{}' in storage: ", (Object)configOid, (Object)ex);
                return null;
            }
            finally {
                payload.close();
            }
        }
        catch (StorageException ex2) {
            log.error("Error accessing object in storage: ", (Throwable)ex2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonSimple parsedFormData(String oid) {
        JsonSimple ex2;
        Payload payload = null;
        try {
            DigitalObject object = this.storage.getObject(oid);
            payload = this.getDataPayload(object);
        }
        catch (StorageException ex2) {
            log.error("Error accessing object '{}' in storage: ", (Object)oid, (Object)ex2);
            return null;
        }
        try {
            ex2 = FormDataParser.parse(payload.open());
        }
        catch (IOException ex3) {
            JsonSimple jsonSimple;
            try {
                log.error("Error parsing data '{}': ", (Object)oid, (Object)ex3);
                jsonSimple = null;
            }
            catch (Throwable throwable) {
                try {
                    payload.close();
                    throw throwable;
                }
                catch (StorageException ex4) {
                    log.error("Error accessing data '{}' in storage: ", (Object)oid, (Object)ex4);
                    return null;
                }
            }
            payload.close();
            return jsonSimple;
        }
        payload.close();
        return ex2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonSimple getDataFromStorage(String oid) {
        JsonSimple ex2;
        Payload payload = null;
        try {
            DigitalObject object = this.storage.getObject(oid);
            payload = this.getDataPayload(object);
        }
        catch (StorageException ex2) {
            log.error("Error accessing object '{}' in storage: ", (Object)oid, (Object)ex2);
            return null;
        }
        try {
            ex2 = new JsonSimple(payload.open());
        }
        catch (IOException ex3) {
            JsonSimple jsonSimple;
            try {
                log.error("Error parsing data '{}': ", (Object)oid, (Object)ex3);
                jsonSimple = null;
            }
            catch (Throwable throwable) {
                try {
                    payload.close();
                    throw throwable;
                }
                catch (StorageException ex4) {
                    log.error("Error accessing data '{}' in storage: ", (Object)oid, (Object)ex4);
                    return null;
                }
            }
            payload.close();
            return jsonSimple;
        }
        payload.close();
        return ex2;
    }

    private Properties getObjectMetadata(String oid) {
        try {
            DigitalObject object = this.storage.getObject(oid);
            return object.getMetadata();
        }
        catch (StorageException ex) {
            log.error("Error accessing object '{}' in storage: ", (Object)oid, (Object)ex);
            return null;
        }
    }

    private void saveObjectData(JsonSimple data, String oid) throws TransactionException {
        DigitalObject object = null;
        try {
            object = this.storage.getObject(oid);
            this.getDataPayload(object);
        }
        catch (StorageException ex) {
            log.error("Error accessing object '{}' in storage: ", (Object)oid, (Object)ex);
            throw new TransactionException((Throwable)ex);
        }
        String jsonString = data.toString(true);
        try {
            this.updateDataPayload(object, jsonString);
        }
        catch (Exception ex) {
            log.error("Unable to store data '{}': ", (Object)oid, (Object)ex);
            throw new TransactionException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonSimple getWorkflowData(String oid) {
        JsonSimple ex2;
        Payload payload = null;
        try {
            DigitalObject object = this.storage.getObject(oid);
            payload = object.getPayload(WORKFLOW_PAYLOAD);
        }
        catch (StorageException ex2) {
            log.error("Error accessing object '{}' in storage: ", (Object)oid, (Object)ex2);
            return null;
        }
        try {
            ex2 = new JsonSimple(payload.open());
        }
        catch (IOException ex3) {
            JsonSimple jsonSimple;
            try {
                log.error("Error parsing workflow '{}': ", (Object)oid, (Object)ex3);
                jsonSimple = null;
            }
            catch (Throwable throwable) {
                try {
                    payload.close();
                    throw throwable;
                }
                catch (StorageException ex4) {
                    log.error("Error accessing workflow '{}' in storage: ", (Object)oid, (Object)ex4);
                    return null;
                }
            }
            payload.close();
            return jsonSimple;
        }
        payload.close();
        return ex2;
    }

    private Payload getDataPayload(DigitalObject object) throws StorageException {
        for (String pid : object.getPayloadIdList()) {
            if (!pid.endsWith(DATA_PAYLOAD_SUFFIX)) continue;
            return object.getPayload(pid);
        }
        throw new StorageException("Data payload not found on storage!");
    }

    private void updateDataPayload(DigitalObject object, String input) throws StorageException {
        try {
            for (String pid : object.getPayloadIdList()) {
                if (!pid.endsWith(DATA_PAYLOAD_SUFFIX)) continue;
                ByteArrayInputStream inStream = new ByteArrayInputStream(input.getBytes("UTF-8"));
                object.updatePayload(pid, (InputStream)inStream);
                return;
            }
            throw new StorageException("Data payload not found on storage!");
        }
        catch (Exception ex) {
            throw new StorageException("Error storing payload data!", (Throwable)ex);
        }
    }
}

