/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.redbox.plugins.curation.redbox;

import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.json.simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormDataParser {
    private static Logger log = LoggerFactory.getLogger(FormDataParser.class);
    private static final List<String> EXCLUDED_FIELDS = Arrays.asList("metaList", "relationships", "responses");

    public static JsonSimple parse(String input) throws IOException {
        ByteArrayInputStream bytes = new ByteArrayInputStream(input.getBytes("UTF-8"));
        return FormDataParser.parse(bytes);
    }

    public static JsonSimple parse(InputStream input) throws IOException {
        JsonSimple inputData = new JsonSimple(input);
        JsonSimple responseData = new JsonSimple();
        JsonObject object = inputData.getJsonObject();
        for (Object key : object.keySet()) {
            String strKey = FormDataParser.validString(key);
            if (EXCLUDED_FIELDS.contains(strKey)) continue;
            String data = FormDataParser.validString(object.get(key));
            FormDataParser.parseField(responseData, strKey, data);
        }
        return responseData;
    }

    private static String validString(Object data) throws IOException {
        if (data == null) {
            return "";
        }
        if (!(data instanceof String)) {
            throw new IOException("Invalid non-String value found!");
        }
        return (String)data;
    }

    private static void parseField(JsonSimple response, String field, String data) throws IOException {
        String[] fieldParts = field.split("\\.");
        JsonObject lastObject = null;
        JSONArray lastArray = null;
        for (int i = 0; i < fieldParts.length; ++i) {
            String segment = fieldParts[i];
            int number = FormDataParser.parseInt(segment);
            if (i == 0) {
                JsonObject topObject = response.getJsonObject();
                if (number != -1) {
                    throw new IOException("Field '" + field + "' starts with" + " an array... this is illegal form data!");
                }
                if (i + 1 == fieldParts.length) {
                    topObject.put((Object)segment, (Object)data);
                    continue;
                }
                String nextSegment = fieldParts[i + 1];
                int nextNumber = FormDataParser.parseInt(nextSegment);
                if (nextNumber == -1) {
                    lastObject = FormDataParser.getObject(topObject, segment);
                    lastArray = null;
                    continue;
                }
                lastObject = null;
                lastArray = FormDataParser.getArray(topObject, segment);
                continue;
            }
            if (i == fieldParts.length - 1) {
                lastObject.put((Object)segment, (Object)data);
                continue;
            }
            String nextSegment = fieldParts[i + 1];
            int nextNumber = FormDataParser.parseInt(nextSegment);
            if (lastArray == null) {
                if (number != -1) {
                    throw new IOException("Field '" + field + "' has an" + " illegal syntax!");
                }
                if (nextNumber == -1) {
                    lastObject = FormDataParser.getObject(lastObject, segment);
                    lastArray = null;
                    continue;
                }
                lastArray = FormDataParser.getArray(lastObject, segment);
                lastObject = null;
                continue;
            }
            if (number == -1) {
                throw new IOException("Field '" + field + "' has an" + " illegal syntax!");
            }
            lastObject = FormDataParser.getObject(lastArray, number);
            lastArray = null;
        }
    }

    private static JsonObject getObject(JSONArray array, int index) throws IOException {
        if (index < 1) {
            throw new IOException("Invalid index value provided in form data.");
        }
        if (array.size() > --index) {
            Object object = array.get(index);
            if (object instanceof JsonObject) {
                return (JsonObject)object;
            }
            throw new IOException("Non-Object found in array!");
        }
        for (int i = array.size(); i <= index; ++i) {
            JsonObject object = new JsonObject();
            array.add((Object)object);
        }
        return (JsonObject)array.get(index);
    }

    private static JSONArray getArray(JsonObject object, String key) throws IOException {
        if (object.containsKey((Object)key)) {
            Object existing = object.get((Object)key);
            if (!(existing instanceof JSONArray)) {
                throw new IOException("Invalid field structure, '" + key + "' expected to be an array, but incompatible " + "data type already present.");
            }
            return (JSONArray)existing;
        }
        JSONArray newObject = new JSONArray();
        object.put((Object)key, (Object)newObject);
        return newObject;
    }

    private static JsonObject getObject(JsonObject object, String key) throws IOException {
        if (object.containsKey((Object)key)) {
            Object existing = object.get((Object)key);
            if (!(existing instanceof JsonObject)) {
                throw new IOException("Invalid field structure, '" + key + "' expected to be an object, but incompatible " + "data type already present.");
            }
            return (JsonObject)existing;
        }
        JsonObject newObject = new JsonObject();
        object.put((Object)key, (Object)newObject);
        return newObject;
    }

    private static int parseInt(String integer) throws IOException {
        try {
            int value = Integer.parseInt(integer);
            if (value < 0) {
                throw new IOException("Invalid number in field name: '" + integer + "'");
            }
            return value;
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }
}

