/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.redbox;

import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.authentication.AuthenticationException;
import com.googlecode.fascinator.api.authentication.User;
import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.indexer.SearchRequest;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.portal.JsonSessionState;
import com.googlecode.fascinator.portal.services.PortalSecurityManager;
import com.googlecode.fascinator.redbox.CacheEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureStorage
implements Storage {
    private static final long DEFAULT_EXPIRY = 30000L;
    private static Map<String, CacheEntry> accessCache = new HashMap<String, CacheEntry>();
    private Logger log = LoggerFactory.getLogger(SecureStorage.class);
    private Storage storage;
    private Indexer indexer;
    private PortalSecurityManager securityManager;
    private JsonSessionState state;
    private String username;
    private List<String> rolesList;

    public SecureStorage(Storage storage, Indexer indexer, PortalSecurityManager securityManager, JsonSessionState state) {
        this.storage = storage;
        this.indexer = indexer;
        this.securityManager = securityManager;
        this.state = state;
        this.setGuestAccess();
    }

    public DigitalObject createObject(String oid) throws StorageException {
        return this.storage.createObject(oid);
    }

    public DigitalObject getObject(String oid) throws StorageException {
        DigitalObject obj = this.storage.getObject(oid);
        if (this.isAccessAllowed(obj)) {
            return obj;
        }
        throw new StorageException("Access denied");
    }

    public void removeObject(String oid) throws StorageException {
        DigitalObject obj = this.getObject(oid);
        this.storage.removeObject(oid);
    }

    public Set<String> getObjectIdList() {
        return this.storage.getObjectIdList();
    }

    public String getId() {
        return this.storage.getId();
    }

    public String getName() {
        return this.storage.getName() + " (secure)";
    }

    public PluginDescription getPluginDetails() {
        return this.storage.getPluginDetails();
    }

    public void init(File jsonFile) throws PluginException {
        this.storage.init(jsonFile);
    }

    public void init(String jsonString) throws PluginException {
        this.storage.init(jsonString);
    }

    public void shutdown() throws PluginException {
        this.storage.shutdown();
    }

    private void updateCredentials() {
        if (this.state.containsKey((Object)"username")) {
            this.username = this.state.get("username").toString();
            try {
                User user = this.securityManager.getUser(this.state, this.username, "system");
                this.rolesList = Arrays.asList(this.securityManager.getRolesList(this.state, user));
            }
            catch (AuthenticationException ae) {
                this.log.error("Failed to get user access, assuming guest access", (Throwable)ae);
                this.setGuestAccess();
            }
        } else {
            this.setGuestAccess();
        }
    }

    private void setGuestAccess() {
        this.username = "guest";
        this.rolesList = new ArrayList<String>();
        this.rolesList.add("guest");
    }

    private boolean isAccessAllowed(DigitalObject obj) throws StorageException {
        if (obj != null) {
            this.updateCredentials();
            String oid = obj.getId();
            try {
                String key = oid + ":" + this.username;
                CacheEntry entry = accessCache.get(key);
                if (entry == null) {
                    entry = new CacheEntry();
                    accessCache.put(key, entry);
                } else {
                    long lastUpdated = entry.getLastUpdated();
                    long now = System.currentTimeMillis();
                    this.log.debug("Elapsed time: {}", (Object)(now - lastUpdated));
                    if (now - lastUpdated > 30000L) {
                        this.log.debug("Cache entry {} expired!", (Object)key);
                        entry = new CacheEntry();
                        accessCache.put(key, entry);
                    } else {
                        this.log.debug("Cached entry {}={}", (Object)key, (Object)entry.isAllowed());
                        return entry.isAllowed();
                    }
                }
                String query = "storage_id:" + oid;
                SearchRequest req = new SearchRequest(query);
                req.setParam("fl", "id");
                req.setParam("fq", "owner:" + this.username + " OR security_filter:(" + StringUtils.join(this.rolesList, (String)" OR ") + ")");
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.indexer.search(req, (OutputStream)out);
                JsonSimple json = new JsonSimple((InputStream)new ByteArrayInputStream(out.toByteArray()));
                List docs = json.getJsonSimpleList(new Object[]{"response", "docs"});
                if (docs.isEmpty()) {
                    entry.setAllowed(false);
                    Properties props = obj.getMetadata();
                    props.store(out, "");
                    if (props.containsKey("fileHash")) {
                        entry.setAllowed(true);
                    } else if (props.containsKey("owner") && props.getProperty("owner").equals(this.username)) {
                        entry.setAllowed(true);
                    }
                    obj.close();
                } else {
                    entry.setAllowed(true);
                }
                return entry.isAllowed();
            }
            catch (StorageException se) {
                throw se;
            }
            catch (Exception e) {
                this.log.error("Failed to get access details", (Throwable)e);
            }
        }
        return false;
    }
}

