/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.redbox;

import com.googlecode.fascinator.api.authentication.AuthenticationException;
import com.googlecode.fascinator.api.authentication.User;
import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.indexer.SearchRequest;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.portal.JsonSessionState;
import com.googlecode.fascinator.portal.services.PortalSecurityManager;
import com.googlecode.fascinator.redbox.SecureStorage;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.ioc.Invocation;
import org.apache.tapestry5.ioc.MethodAdvice;
import org.apache.tapestry5.ioc.MethodAdviceReceiver;
import org.apache.tapestry5.ioc.annotations.Match;
import org.apache.tapestry5.services.ApplicationStateManager;
import org.apache.tapestry5.services.RequestGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalModule {
    private static String GUEST_USER = "guest";
    private static String GUEST_ROLE = "guest";
    private Logger log = LoggerFactory.getLogger(PortalModule.class);

    @Match(value={"ScriptingServices"})
    public static void adviseSafe(Logger log, final ApplicationStateManager appStateManager, final Indexer indexer, final PortalSecurityManager securityManager, MethodAdviceReceiver receiver) {
        MethodAdvice advice = new MethodAdvice(){

            public void advise(Invocation invocation) {
                invocation.proceed();
                Storage storage = (Storage)invocation.getResult();
                invocation.overrideResult((Object)new SecureStorage(storage, indexer, securityManager, (JsonSessionState)appStateManager.getIfExists(JsonSessionState.class)));
            }
        };
        try {
            Method method = receiver.getInterface().getMethod("getStorage", new Class[0]);
            receiver.adviseMethod(method, advice);
        }
        catch (Exception e) {
            log.error("Failed to advise: {}", (Object)e.getMessage());
        }
    }

    @Match(value={"Indexer"})
    public static void adviseSafeIndexer(final Logger log, final ApplicationStateManager appStateManager, RequestGlobals requestGlobals, Indexer indexer, final PortalSecurityManager securityManager, MethodAdviceReceiver receiver) {
        MethodAdvice advice = new MethodAdvice(){

            public void advise(Invocation invocation) {
                SearchRequest request = (SearchRequest)invocation.getParameter(0);
                boolean hasSecurityFilter = false;
                Set fqList = request.getParams("fq");
                if (fqList != null) {
                    for (String fq : fqList) {
                        if (!fq.contains("owner:") && !fq.contains("security_filter:") && !fq.contains("security_exception:") && !fq.contains("workflow_security:")) continue;
                        hasSecurityFilter = true;
                        break;
                    }
                }
                if (!hasSecurityFilter) {
                    log.debug("Adding security to Solr request: {}", (Object)request);
                    JsonSessionState state = (JsonSessionState)appStateManager.getIfExists(JsonSessionState.class);
                    String username = GUEST_USER;
                    List<String> rolesList = null;
                    if (state.containsKey((Object)"username")) {
                        username = state.get("username").toString();
                        String source = state.containsKey((Object)"source") ? state.get("source").toString() : "system";
                        try {
                            User user = securityManager.getUser(state, username, source);
                            rolesList = Arrays.asList(securityManager.getRolesList(state, user));
                        }
                        catch (AuthenticationException ae) {
                            log.error("Failed to get user access, assuming guest access", (Throwable)ae);
                            rolesList = new ArrayList();
                            rolesList.add(GUEST_ROLE);
                        }
                    } else {
                        rolesList = new ArrayList<String>();
                        rolesList.add(GUEST_ROLE);
                    }
                    request.addParam("fq", "owner:" + username + " OR security_filter:(" + StringUtils.join(rolesList, (String)" OR ") + ")");
                    invocation.override(0, (Object)request);
                }
                invocation.proceed();
            }
        };
        try {
            Method method = receiver.getInterface().getMethod("search", SearchRequest.class, OutputStream.class);
            receiver.adviseMethod(method, advice);
        }
        catch (Exception e) {
            log.error("Failed to advise: {}", (Object)e.getMessage());
        }
    }
}

