package io.k8s.api.core.v1

/* Affinity is a group of affinity scheduling rules. */
import io.circe._
import io.circe.generic.semiauto._

case class Affinity(
  /* Describes node affinity scheduling rules for the pod. */
  nodeAffinity: Option[io.k8s.api.core.v1.NodeAffinity] = None,
  /* Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)). */
  podAffinity: Option[io.k8s.api.core.v1.PodAffinity] = None,
  /* Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)). */
  podAntiAffinity: Option[io.k8s.api.core.v1.PodAntiAffinity] = None
)

object Affinity {
  implicit lazy val encoder: Encoder.AsObject[Affinity] = deriveEncoder
  implicit lazy val decoder: Decoder[Affinity] = deriveDecoder
}
