package io.k8s.api.policy.v1beta1

/* AllowedCSIDriver represents a single inline CSI Driver that is allowed to be used. */
import io.circe._
import io.circe.generic.semiauto._

case class AllowedCSIDriver(
  /* Name is the registered name of the CSI driver */
  name: String
)

object AllowedCSIDriver {
  implicit lazy val encoder: Encoder.AsObject[AllowedCSIDriver] = deriveEncoder
  implicit lazy val decoder: Decoder[AllowedCSIDriver] = deriveDecoder
}
