package io.k8s.api.core.v1

/* AzureFile represents an Azure File Service mount on the host and bind mount to the pod. */
import io.circe._
import io.circe.generic.semiauto._

case class AzureFileVolumeSource(
  /* the name of secret that contains Azure Storage Account Name and Key */
  secretName: String,
  /* Share Name */
  shareName: String,
  /* Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. */
  readOnly: Option[Boolean] = None
)

object AzureFileVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[AzureFileVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[AzureFileVolumeSource] = deriveDecoder
}
