package io.k8s.api.core.v1

/* Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling. */
import io.circe._
import io.circe.generic.semiauto._

case class CinderPersistentVolumeSource(
  /* volume id used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md */
  volumeID: String,
  /* Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md */
  fsType: Option[String] = None,
  /* Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md */
  readOnly: Option[Boolean] = None,
  /* Optional: points to a secret object containing parameters used to connect to OpenStack. */
  secretRef: Option[io.k8s.api.core.v1.SecretReference] = None
)

object CinderPersistentVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[CinderPersistentVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[CinderPersistentVolumeSource] = deriveDecoder
}
