package io.k8s.api.rbac.v1

/* ClusterRoleList is a collection of ClusterRoles */
import io.circe._
import io.circe.generic.semiauto._

case class ClusterRoleList(
  /* Items is a list of ClusterRoles */
  items: Seq[io.k8s.api.rbac.v1.ClusterRole],
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  /* Standard object's metadata. */
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
)

object ClusterRoleList {
  implicit lazy val encoder: Encoder.AsObject[ClusterRoleList] = deriveEncoder
  implicit lazy val decoder: Decoder[ClusterRoleList] = deriveDecoder
}
