package io.k8s.api.core.v1

/* Information about the condition of a component. */
import io.circe._
import io.circe.generic.semiauto._

case class ComponentCondition(
  /* Type of condition for a component. Valid value: "Healthy" */
  `type`: String,
  /* Status of the condition for a component. Valid values for "Healthy": "True", "False", or "Unknown". */
  status: String,
  /* Condition error code for a component. For example, a health check error code. */
  error: Option[String] = None,
  /* Message about the condition for a component. For example, information about a health check. */
  message: Option[String] = None
)

object ComponentCondition {
  implicit lazy val encoder: Encoder.AsObject[ComponentCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[ComponentCondition] = deriveDecoder
}
