package io.k8s.api.core.v1

/* ComponentStatus (and ComponentStatusList) holds the cluster validation info. */
import io.circe._
import io.circe.generic.semiauto._

case class ComponentStatus(
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* List of component conditions observed */
  conditions: Option[Seq[io.k8s.api.core.v1.ComponentCondition]] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  /* Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata */
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
)

object ComponentStatus {
  implicit lazy val encoder: Encoder.AsObject[ComponentStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[ComponentStatus] = deriveDecoder
}
