package io.k8s.api.core.v1

/* ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node. */
import io.circe._
import io.circe.generic.semiauto._

case class ConfigMapNodeConfigSource(
  /* Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases. */
  namespace: String,
  /* Name is the metadata.name of the referenced ConfigMap. This field is required in all cases. */
  name: String,
  /* KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases. */
  kubeletConfigKey: String,
  /* ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status. */
  resourceVersion: Option[String] = None,
  /* UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status. */
  uid: Option[String] = None
)

object ConfigMapNodeConfigSource {
  implicit lazy val encoder: Encoder.AsObject[ConfigMapNodeConfigSource] = deriveEncoder
  implicit lazy val decoder: Decoder[ConfigMapNodeConfigSource] = deriveDecoder
}
