package io.k8s.api.core.v1

/* Describe a container image */
import io.circe._
import io.circe.generic.semiauto._

case class ContainerImage(
  /* Names by which this image is known. e.g. ["k8s.gcr.io/hyperkube:v1.0.7", "dockerhub.io/google_containers/hyperkube:v1.0.7"] */
  names: Seq[String],
  /* The size of the image in bytes. */
  sizeBytes: Option[Long] = None
)

object ContainerImage {
  implicit lazy val encoder: Encoder.AsObject[ContainerImage] = deriveEncoder
  implicit lazy val decoder: Decoder[ContainerImage] = deriveDecoder
}
