package io.k8s.api.core.v1

/* ContainerState holds a possible state of container. Only one of its members may be specified. If none of them is specified, the default one is ContainerStateWaiting. */
import io.circe._
import io.circe.generic.semiauto._

case class ContainerState(
  /* Details about a running container */
  running: Option[io.k8s.api.core.v1.ContainerStateRunning] = None,
  /* Details about a terminated container */
  terminated: Option[io.k8s.api.core.v1.ContainerStateTerminated] = None,
  /* Details about a waiting container */
  waiting: Option[io.k8s.api.core.v1.ContainerStateWaiting] = None
)

object ContainerState {
  implicit lazy val encoder: Encoder.AsObject[ContainerState] = deriveEncoder
  implicit lazy val decoder: Decoder[ContainerState] = deriveDecoder
}
