package io.k8s.api.core.v1

/* ContainerStatus contains details for the current status of this container. */
import io.circe._
import io.circe.generic.semiauto._

case class ContainerStatus(
  /* This must be a DNS_LABEL. Each container in a pod must have a unique name. Cannot be updated. */
  name: String,
  /* Specifies whether the container has passed its readiness probe. */
  ready: Boolean,
  /* The number of times the container has been restarted, currently based on the number of dead containers that have not yet been removed. Note that this is calculated from dead containers. But those containers are subject to garbage collection. This value will get capped at 5 by GC. */
  restartCount: Int,
  /* The image the container is running. More info: https://kubernetes.io/docs/concepts/containers/images */
  image: String,
  /* ImageID of the container's image. */
  imageID: String,
  /* Container's ID in the format 'docker://<container_id>'. */
  containerID: Option[String] = None,
  /* Details about the container's last termination condition. */
  lastState: Option[io.k8s.api.core.v1.ContainerState] = None,
  /* Specifies whether the container has passed its startup probe. Initialized as false, becomes true after startupProbe is considered successful. Resets to false when the container is restarted, or if kubelet loses state temporarily. Is always true when no startupProbe is defined. */
  started: Option[Boolean] = None,
  /* Details about the container's current condition. */
  state: Option[io.k8s.api.core.v1.ContainerState] = None
)

object ContainerStatus {
  implicit lazy val encoder: Encoder.AsObject[ContainerStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[ContainerStatus] = deriveDecoder
}
