package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

/* CustomResourceDefinition represents a resource that should be exposed on the API server.  Its name MUST be in the format <.spec.name>.<.spec.group>. */
import io.circe._
import io.circe.generic.semiauto._

case class CustomResourceDefinition(
  /* spec describes how the user wants the resources to appear */
  spec: io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec,
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  /* status indicates the actual state of the CustomResourceDefinition */
  status: Option[io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus] = None
)

object CustomResourceDefinition {
  implicit lazy val encoder: Encoder.AsObject[CustomResourceDefinition] = deriveEncoder
  implicit lazy val decoder: Decoder[CustomResourceDefinition] = deriveDecoder
}
