package io.k8s.api.apps.v1

/* DaemonSet represents the configuration of a daemon set. */
import io.circe._
import io.circe.generic.semiauto._

case class DaemonSet(
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  /* Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata */
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  /* The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status */
  spec: Option[io.k8s.api.apps.v1.DaemonSetSpec] = None,
  /* The current status of this daemon set. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status */
  status: Option[io.k8s.api.apps.v1.DaemonSetStatus] = None
)

object DaemonSet {
  implicit lazy val encoder: Encoder.AsObject[DaemonSet] = deriveEncoder
  implicit lazy val decoder: Decoder[DaemonSet] = deriveDecoder
}
