package io.k8s.api.apps.v1

/* DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet. */
import io.circe._
import io.circe.generic.semiauto._

case class DaemonSetUpdateStrategy(
  /* Rolling update config params. Present only if type = "RollingUpdate". */
  rollingUpdate: Option[io.k8s.api.apps.v1.RollingUpdateDaemonSet] = None,
  /* Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate. */
  `type`: Option[String] = None
)

object DaemonSetUpdateStrategy {
  implicit lazy val encoder: Encoder.AsObject[DaemonSetUpdateStrategy] = deriveEncoder
  implicit lazy val decoder: Decoder[DaemonSetUpdateStrategy] = deriveDecoder
}
