package io.k8s.api.apps.v1

/* DeploymentStatus is the most recently observed status of the Deployment. */
import io.circe._
import io.circe.generic.semiauto._

case class DeploymentStatus(
  /* Total number of available pods (ready for at least minReadySeconds) targeted by this deployment. */
  availableReplicas: Option[Int] = None,
  /* Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet. */
  collisionCount: Option[Int] = None,
  /* Represents the latest available observations of a deployment's current state. */
  conditions: Option[Seq[io.k8s.api.apps.v1.DeploymentCondition]] = None,
  /* The generation observed by the deployment controller. */
  observedGeneration: Option[Long] = None,
  /* Total number of ready pods targeted by this deployment. */
  readyReplicas: Option[Int] = None,
  /* Total number of non-terminated pods targeted by this deployment (their labels match the selector). */
  replicas: Option[Int] = None,
  /* Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created. */
  unavailableReplicas: Option[Int] = None,
  /* Total number of non-terminated pods targeted by this deployment that have the desired template spec. */
  updatedReplicas: Option[Int] = None
)

object DeploymentStatus {
  implicit lazy val encoder: Encoder.AsObject[DeploymentStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[DeploymentStatus] = deriveDecoder
}
