package io.k8s.api.core.v1

/* DownwardAPIVolumeFile represents information to create the file containing the pod field */
import io.circe._
import io.circe.generic.semiauto._

case class DownwardAPIVolumeFile(
  /* Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..' */
  path: String,
  /* Required: Selects a field of the pod: only annotations, labels, name and namespace are supported. */
  fieldRef: Option[io.k8s.api.core.v1.ObjectFieldSelector] = None,
  /* Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. */
  mode: Option[Int] = None,
  /* Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported. */
  resourceFieldRef: Option[io.k8s.api.core.v1.ResourceFieldSelector] = None
)

object DownwardAPIVolumeFile {
  implicit lazy val encoder: Encoder.AsObject[DownwardAPIVolumeFile] = deriveEncoder
  implicit lazy val decoder: Decoder[DownwardAPIVolumeFile] = deriveDecoder
}
