package io.k8s.api.core.v1

/* EndpointPort is a tuple that describes a single port. */
import io.circe._
import io.circe.generic.semiauto._

case class EndpointPort(
  /* The port number of the endpoint. */
  port: Int,
  /* The application protocol for this port. This field follows standard Kubernetes label syntax. Un-prefixed names are reserved for IANA standard service names (as per RFC-6335 and http://www.iana.org/assignments/service-names). Non-standard protocols should use prefixed names such as mycompany.com/my-custom-protocol. Field can be enabled with ServiceAppProtocol feature gate. */
  appProtocol: Option[String] = None,
  /* The name of this port.  This must match the 'name' field in the corresponding ServicePort. Must be a DNS_LABEL. Optional only if one port is defined. */
  name: Option[String] = None,
  /* The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP. */
  protocol: Option[String] = None
)

object EndpointPort {
  implicit lazy val encoder: Encoder.AsObject[EndpointPort] = deriveEncoder
  implicit lazy val decoder: Decoder[EndpointPort] = deriveDecoder
}
