package io.k8s.api.core.v1

/* EnvFromSource represents the source of a set of ConfigMaps */
import io.circe._
import io.circe.generic.semiauto._

case class EnvFromSource(
  /* The ConfigMap to select from */
  configMapRef: Option[io.k8s.api.core.v1.ConfigMapEnvSource] = None,
  /* An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER. */
  prefix: Option[String] = None,
  /* The Secret to select from */
  secretRef: Option[io.k8s.api.core.v1.SecretEnvSource] = None
)

object EnvFromSource {
  implicit lazy val encoder: Encoder.AsObject[EnvFromSource] = deriveEncoder
  implicit lazy val decoder: Decoder[EnvFromSource] = deriveDecoder
}
