package io.k8s.api.core.v1

/* EventSource contains information for an event. */
import io.circe._
import io.circe.generic.semiauto._

case class EventSource(
  /* Component from which the event is generated. */
  component: Option[String] = None,
  /* Node name on which the event is generated. */
  host: Option[String] = None
)

object EventSource {
  implicit lazy val encoder: Encoder.AsObject[EventSource] = deriveEncoder
  implicit lazy val decoder: Decoder[EventSource] = deriveDecoder
}
