package io.k8s.api.policy.v1beta1

/* Eviction evicts a pod from its node subject to certain policies and safety constraints. This is a subresource of Pod.  A request to cause such an eviction is created by POSTing to .../pods/<pod name>/evictions. */
import io.circe._
import io.circe.generic.semiauto._

case class Eviction(
  /* APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources */
  apiVersion: Option[String] = None,
  /* DeleteOptions may be provided */
  deleteOptions: Option[io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions] = None,
  /* Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds */
  kind: Option[String] = None,
  /* ObjectMeta describes the pod that is being evicted. */
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
)

object Eviction {
  implicit lazy val encoder: Encoder.AsObject[Eviction] = deriveEncoder
  implicit lazy val decoder: Decoder[Eviction] = deriveDecoder
}
