package io.k8s.api.core.v1

/* ExecAction describes a "run in container" action. */
import io.circe._
import io.circe.generic.semiauto._

case class ExecAction(
  /* Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy. */
  command: Option[Seq[String]] = None
)

object ExecAction {
  implicit lazy val encoder: Encoder.AsObject[ExecAction] = deriveEncoder
  implicit lazy val decoder: Decoder[ExecAction] = deriveDecoder
}
