package io.k8s.api.core.v1

/* Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling. */
import io.circe._
import io.circe.generic.semiauto._

case class FCVolumeSource(
  /* Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. */
  fsType: Option[String] = None,
  /* Optional: FC target lun number */
  lun: Option[Int] = None,
  /* Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. */
  readOnly: Option[Boolean] = None,
  /* Optional: FC target worldwide names (WWNs) */
  targetWWNs: Option[Seq[String]] = None,
  /* Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously. */
  wwids: Option[Seq[String]] = None
)

object FCVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[FCVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[FCVolumeSource] = deriveDecoder
}
