package io.k8s.api.policy.v1beta1

/* FSGroupStrategyOptions defines the strategy type and options used to create the strategy. */
import io.circe._
import io.circe.generic.semiauto._

case class FSGroupStrategyOptions(
  /* ranges are the allowed ranges of fs groups.  If you would like to force a single fs group then supply a single range with the same start and end. Required for MustRunAs. */
  ranges: Option[Seq[io.k8s.api.policy.v1beta1.IDRange]] = None,
  /* rule is the strategy that will dictate what FSGroup is used in the SecurityContext. */
  rule: Option[String] = None
)

object FSGroupStrategyOptions {
  implicit lazy val encoder: Encoder.AsObject[FSGroupStrategyOptions] = deriveEncoder
  implicit lazy val decoder: Decoder[FSGroupStrategyOptions] = deriveDecoder
}
