package io.k8s.api.core.v1

/* Represents a Flocker volume mounted by the Flocker agent. One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling. */
import io.circe._
import io.circe.generic.semiauto._

case class FlockerVolumeSource(
  /* Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated */
  datasetName: Option[String] = None,
  /* UUID of the dataset. This is unique identifier of a Flocker dataset */
  datasetUUID: Option[String] = None
)

object FlockerVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[FlockerVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[FlockerVolumeSource] = deriveDecoder
}
