package io.k8s.api.core.v1

/* Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling. */
import io.circe._
import io.circe.generic.semiauto._

case class GlusterfsVolumeSource(
  /* EndpointsName is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod */
  endpoints: String,
  /* Path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod */
  path: String,
  /* ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod */
  readOnly: Option[Boolean] = None
)

object GlusterfsVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[GlusterfsVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[GlusterfsVolumeSource] = deriveDecoder
}
