package io.k8s.api.core.v1

/* HTTPGetAction describes an action based on HTTP Get requests. */
import io.circe._
import io.circe.generic.semiauto._

case class HTTPGetAction(
  /* Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME. */
  port: com.goyeau.kubernetes.client.IntOrString,
  /* Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead. */
  host: Option[String] = None,
  /* Custom headers to set in the request. HTTP allows repeated headers. */
  httpHeaders: Option[Seq[io.k8s.api.core.v1.HTTPHeader]] = None,
  /* Path to access on the HTTP server. */
  path: Option[String] = None,
  /* Scheme to use for connecting to the host. Defaults to HTTP. */
  scheme: Option[String] = None
)

object HTTPGetAction {
  implicit lazy val encoder: Encoder.AsObject[HTTPGetAction] = deriveEncoder
  implicit lazy val decoder: Decoder[HTTPGetAction] = deriveDecoder
}
