package io.k8s.api.core.v1

/* Handler defines a specific action that should be taken */
import io.circe._
import io.circe.generic.semiauto._

case class Handler(
  /* One and only one of the following should be specified. Exec specifies the action to take. */
  exec: Option[io.k8s.api.core.v1.ExecAction] = None,
  /* HTTPGet specifies the http request to perform. */
  httpGet: Option[io.k8s.api.core.v1.HTTPGetAction] = None,
  /* TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported */
  tcpSocket: Option[io.k8s.api.core.v1.TCPSocketAction] = None
)

object Handler {
  implicit lazy val encoder: Encoder.AsObject[Handler] = deriveEncoder
  implicit lazy val decoder: Decoder[Handler] = deriveDecoder
}
