package io.k8s.api.autoscaling.v1

/* current status of a horizontal pod autoscaler */
import io.circe._
import io.circe.generic.semiauto._

case class HorizontalPodAutoscalerStatus(
  /* current number of replicas of pods managed by this autoscaler. */
  currentReplicas: Int,
  /* desired number of replicas of pods managed by this autoscaler. */
  desiredReplicas: Int,
  /* current average CPU utilization over all pods, represented as a percentage of requested CPU, e.g. 70 means that an average pod is using now 70% of its requested CPU. */
  currentCPUUtilizationPercentage: Option[Int] = None,
  /* last time the HorizontalPodAutoscaler scaled the number of pods; used by the autoscaler to control how often the number of pods is changed. */
  lastScaleTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  /* most recent generation observed by this autoscaler. */
  observedGeneration: Option[Long] = None
)

object HorizontalPodAutoscalerStatus {
  implicit lazy val encoder: Encoder.AsObject[HorizontalPodAutoscalerStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[HorizontalPodAutoscalerStatus] = deriveDecoder
}
