package io.k8s.api.core.v1

/* HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file. */
import io.circe._
import io.circe.generic.semiauto._

case class HostAlias(
  /* Hostnames for the above IP address. */
  hostnames: Option[Seq[String]] = None,
  /* IP address of the host file entry. */
  ip: Option[String] = None
)

object HostAlias {
  implicit lazy val encoder: Encoder.AsObject[HostAlias] = deriveEncoder
  implicit lazy val decoder: Decoder[HostAlias] = deriveDecoder
}
