package io.k8s.api.policy.v1beta1

/* HostPortRange defines a range of host ports that will be enabled by a policy for pods to use.  It requires both the start and end to be defined. */
import io.circe._
import io.circe.generic.semiauto._

case class HostPortRange(
  /* min is the start of the range, inclusive. */
  min: Int,
  /* max is the end of the range, inclusive. */
  max: Int
)

object HostPortRange {
  implicit lazy val encoder: Encoder.AsObject[HostPortRange] = deriveEncoder
  implicit lazy val decoder: Decoder[HostPortRange] = deriveDecoder
}
